JSON_RESPONSE_SPLITTER = '// yandex-splitter'


class UnexpectedEmptyString(Exception):
    pass


def split_jsonp(jsonp_str, allow_json=True):
    """Extracts callback name and JS object from jsonp string

    :param jsonp_str:
    :param allow_json: allow pure json
    :returns: callback name, JS object
    >>> split_jsonp("({})")
    ('', '{}')
    >>> split_jsonp("{}", allow_json=True)
    ('', '{}')
    >>> split_jsonp("{}", allow_json=False)
    Traceback (most recent call last):
        ...
    ValueError: jsonp expected, got regular json
    >>> split_jsonp("")
    Traceback (most recent call last):
        ...
    UnexpectedEmptyString: got empty string
    >>> split_jsonp("callback({})")
    ('callback', '{}')
    >>> split_jsonp("callback('{}')")
    ('callback', '{}')
    """
    if jsonp_str.startswith("{"):
        if allow_json:
            return "", jsonp_str
        raise ValueError("jsonp expected, got regular json")
    if not jsonp_str:
        raise UnexpectedEmptyString("got empty string")
    l_index = jsonp_str.index("(") + 1
    r_index = jsonp_str.rindex(")")
    prefix = jsonp_str[:l_index - 1]
    return prefix, jsonp_str[l_index:r_index].strip("'")


def extract_json_from_jsonp(jsonp_str, allow_json=True):
    _, extracted_str = split_jsonp(jsonp_str, allow_json=allow_json)
    return extracted_str
