import time
import logging


YT_TABLE_PATH = "//home/yabs-cs-sandbox/saas/Topologies"
logger = logging.getLogger(__name__)


def add_record(yt_client, resource_id, ttl):
    """
    :param ttl: TTL for record in seconds
    :type ttl: int
    """
    now = int(time.time())
    row = {
        "resource_id": resource_id,
        "creation_time": now,
        "access_time": now,
        "expiration_time": now + ttl,
    }
    yt_client.insert_rows(YT_TABLE_PATH, [row], format='json')


def delete_record(yt_client, resource_id):
    row = {
        "resource_id": resource_id,
    }
    yt_client.delete_rows(YT_TABLE_PATH, [row], format='json')


def extend_expiration_time(yt_client, resource_id, ttl):
    try:
        row = list(yt_client.lookup_rows(YT_TABLE_PATH, [{"resource_id": resource_id}], format='json'))[0]
    except IndexError:
        return
    now = int(time.time())
    row["expiration_time"] = int(max(now + ttl, row["expiration_time"]))
    yt_client.insert_rows(YT_TABLE_PATH, [row], format='json')


def get_active_snapshot_metas_kvrs(yt_client, table_path=YT_TABLE_PATH):
    rows = list(yt_client.read_table(table_path, format='json'))
    logger.debug('Got active snapshots data from %s: %s', table_path, rows)
    return [row["resource_id"] for row in rows]


def get_snapshot_metas_kvrs_to_delete(yt_client, table_path=YT_TABLE_PATH):
    rows = list(yt_client.read_table(table_path, format='json'))
    logger.debug('Got active snapshots data from %s: %s', table_path, rows)
    resource_ids_to_delete = []
    now = int(time.time())
    for row in rows:
        if row["expiration_time"] < now:
            resource_ids_to_delete.append(row["resource_id"])
    return resource_ids_to_delete
