from abc import ABCMeta, abstractmethod


class LocalServerModuleInterface(object):

    __metaclass__ = ABCMeta
    """
    Interface class for modules encapsulating localhost HTTP server.
    """

    @abstractmethod
    def __enter__(self):
        """
        Launches the server.
        """
        pass

    @abstractmethod
    def __exit__(self, *args):
        """
        Stops the server, waits for complete shutdown.
        """
        pass

    @abstractmethod
    def get_port(self):
        """
        If server is active, returns port that the server is bound to.
        Otherwise, returns None.
        """
        pass
