from sandbox import sdk2
from sandbox.projects.yabs.qa.resource_types import (
    BS_RELEASE_TAR,
    BS_RELEASE_YT,
    YABS_CS_INPUT_SPEC,
    YABS_CS_SETTINGS_ARCHIVE,
    YABS_MYSQL_ARCHIVE_CONTENTS,
    YABS_SERVER_TESTENV_SHARD_MAP,
    YABS_SERVER_TESTENV_DB_FLAGS,
    YabsServerExtServiceEndpoint,
)
from sandbox.projects.yabs.qa.spec.constants import META_MODES
from sandbox.projects.YabsLmService.resource_types import YABS_LINEAR_MODELS_EXECUTABLE
from sandbox.projects.yabs.qa.tasks.YabsServerFreezeCurrentKvrsSaasSnapshot import YabsServerSaasTopology


class ShootParameters(sdk2.Parameters):
    with sdk2.parameters.Group('FT settings') as ft_settings:
        ft_shards = sdk2.parameters.List('FT shards', default=['A'])
        with sdk2.parameters.CheckGroup('Roles to shoot ft', default=META_MODES) as ft_meta_modes:
            ft_meta_modes.choices = (
                (meta_mode, meta_mode)
                for meta_mode in META_MODES
            )

    with sdk2.parameters.Group('Stat load settings') as stat_load_settings:
        stat_load = sdk2.parameters.Bool('Launch stat load tasks', default=False)
        with stat_load.value[True]:
            stat_load_shards = sdk2.parameters.List('STAT LOAD shards', default=['A', 'B'])
            with sdk2.parameters.CheckGroup('Roles to shoot stat_load', default=META_MODES) as stat_load_meta_modes:
                stat_load_meta_modes.choices = (
                    (meta_mode, meta_mode)
                    for meta_mode in META_MODES
                )

    with sdk2.parameters.Group('Meta load settings') as meta_load_settings:
        meta_load = sdk2.parameters.Bool('Launch meta load tasks', default=False)
        with meta_load.value[True]:
            meta_load_shards = sdk2.parameters.List('META LOAD shards', default=['A', 'B'])
            with sdk2.parameters.CheckGroup('Roles to shoot meta_load', default=META_MODES) as meta_load_meta_modes:
                meta_load_meta_modes.choices = (
                    (meta_mode, meta_mode)
                    for meta_mode in META_MODES
                )
    with sdk2.parameters.Group('External services') as external_services:
        ext_service_endpoint_resources = sdk2.parameters.Resource('Resources with endpoint set of external services', resource_type=YabsServerExtServiceEndpoint, multiple=True)
        hamster_ext_service_tags = sdk2.parameters.JSON(
            "Hamster service tags",
            default_value={"bs": [], "yabs": [], "bsrank": []})
        saas_frozen_topology = sdk2.parameters.Resource('Resource with Saas frozen topology', resource_type=YabsServerSaasTopology)


class ServerResourceParameters(sdk2.Parameters):
    with sdk2.parameters.Group("Server resources") as server_resources_group:
        bs_release_tar_resource = sdk2.parameters.Resource("BS_RELEASE_TAR resource, will find last released if empty", resource_type=BS_RELEASE_TAR)
        bs_release_yt_resource = sdk2.parameters.Resource("BS_RELEASE_YT resource, will find matching with BS_RELEASE_TAR if empty", resource_type=BS_RELEASE_YT)

        stat_bs_release_tar_resource = sdk2.parameters.Resource("Stat BS_RELEASE_TAR resource, will find last released if empty", resource_type=BS_RELEASE_TAR)
        stat_bs_release_yt_resource = sdk2.parameters.Resource("Stat BS_RELEASE_YT resource, will find matching with BS_RELEASE_TAR if empty", resource_type=BS_RELEASE_YT)

        meta_bs_release_tar_resource = sdk2.parameters.Resource("Meta BS_RELEASE_TAR resource, will find last released if empty", resource_type=BS_RELEASE_TAR)
        meta_bs_release_yt_resource = sdk2.parameters.Resource("Meta BS_RELEASE_YT resource, will find matching with BS_RELEASE_TAR if empty", resource_type=BS_RELEASE_YT)


class DataResourceParameters(sdk2.Parameters):
    with sdk2.parameters.Group("Data resources") as data_resources_group:
        mysql_archive_resource = sdk2.parameters.Resource("MySQL archive, will find last ready with testenv_switch_trigger if empty", resource_type=YABS_MYSQL_ARCHIVE_CONTENTS)
        cs_input_spec_resource = sdk2.parameters.Resource("YT input archive, will find last ready with testenv_switch_trigger if empty", resource_type=YABS_CS_INPUT_SPEC)
        cs_settings_archive_resource = sdk2.parameters.Resource("CS settings archive, will find last ready with testenv_switch_trigger if empty", resource_type=YABS_CS_SETTINGS_ARCHIVE)


class AmmoResourceParameters(sdk2.Parameters):
    with sdk2.parameters.Group("Ammo resources") as ammo_resources_group:
        ft_request_log_resource_id_map = sdk2.parameters.JSON(
            "Role to ft request_log resource id mapping, will find last resources if empty",
            default={meta_mode: None for meta_mode in META_MODES}
        )
        stat_load_request_log_resource_id_map = sdk2.parameters.JSON(
            "Role to stat_load request_log resource id mapping, will find last resources if empty",
            default={meta_mode: None for meta_mode in META_MODES}
        )
        meta_load_request_log_resource_id_map = sdk2.parameters.JSON(
            "Role to meta_load request_log resource id mapping, will find last resources if empty",
            default={meta_mode: None for meta_mode in META_MODES}
        )
        dolbilka_plan_resource_id_map = sdk2.parameters.JSON(
            "Role to stat_load dolbilka_plan resource id mapping, will find last resources if empty",
            default={meta_mode: None for meta_mode in META_MODES}
        )


class MiscResourceParameters(sdk2.Parameters):
    with sdk2.parameters.Group("Miscellaneous resources") as misc_resources_group:
        shard_map_resource = sdk2.parameters.Resource("Shard map, will find last ready if empty", resource_type=YABS_SERVER_TESTENV_SHARD_MAP)
        gen_bin_bases_flags_resource = sdk2.parameters.Resource("Bin bases flags resource, will find last ready if empty", resource_type=YABS_SERVER_TESTENV_DB_FLAGS)
        ft_shoot_settings_resource = sdk2.parameters.Resource("FT update parameters resource, will find last ready if empty", resource_type=YABS_SERVER_TESTENV_DB_FLAGS)
        load_shoot_settings_resource = sdk2.parameters.Resource("LOAD update parameters resource, will find last ready if empty", resource_type=YABS_SERVER_TESTENV_DB_FLAGS)
        meta_load_shoot_settings_resource = sdk2.parameters.Resource("META LOAD update parameters resource, will find last ready if empty", resource_type=YABS_SERVER_TESTENV_DB_FLAGS)
        linear_models_binary_resource = sdk2.parameters.Resource("LINEAR MODELS update parameters resource, will find last ready if empty", resource_type=YABS_LINEAR_MODELS_EXECUTABLE)


class BaseSpecParameters(sdk2.Parameters):
    release_spec = sdk2.parameters.Bool('Release spec for public use', default=False, do_not_copy=True)
    sanity_check = sdk2.parameters.Bool('Check stability tasks', default=True)

    shoot_settings = ShootParameters()
    server_resources = ServerResourceParameters()
    data_resources = DataResourceParameters()
    ammo_resources = AmmoResourceParameters()
    misc_resources = MiscResourceParameters()

    use_separated_meta_and_stat = sdk2.parameters.Bool('Use separated meta and stat in shoot tasks', default=False)
