from sandbox.common.types.misc import NotExists

BUILD_FIELDS = [
    'stat_bs_release_tar_resource_id',
    'stat_bs_release_yt_resource_id',
    'meta_bs_release_tar_resource_id',
    'meta_bs_release_yt_resource_id',
]
DATA_FIELDS = [
    'mysql_archive_resource_id',
    'cs_input_spec_resource_id',
    'cs_settings_archive_resource_id',
]
EXT_SERVICE_FIELDS = [
    'ext_service_endpoint_resource_ids',
]
BASES_FIELDS = [
    'shard_map_resource_id',
    'stat_setup_ya_make_task_id',
    'meta_setup_ya_make_task_id',
    'gen_bin_bases_flags_resource_id',
    'stat_base_tags_map',
    'stat_binary_base_resource_id_by_tag',
    'meta_base_tags_map',
    'meta_binary_base_resource_id_by_tag',
]
FT_FIELDS = [
    'ft_shoot_settings_resource_id',
    'ft_request_log_resource_id_map',
    'ft_shoot_tasks',
]
STAT_LOAD_FIELDS = [
    'stat_load_request_log_resource_id_map',
    'stat_load_baseline_tasks',
]
META_LOAD_FIELDS = [
    'meta_load_request_log_resource_id_map',
    'meta_load_baseline_tasks',
]
MISC_FIELDS = [
    'use_separated_meta_and_stat',
]


class BaseSpec(object):
    __slots__ = BUILD_FIELDS + DATA_FIELDS + EXT_SERVICE_FIELDS + BASES_FIELDS + FT_FIELDS + STAT_LOAD_FIELDS + META_LOAD_FIELDS + MISC_FIELDS

    def __init__(self, context, **kwargs):
        for item in self.__slots__:
            if item in kwargs:
                setattr(self, item, kwargs[item])
                continue

            value = getattr(context, item)
            if value is NotExists:
                raise ValueError('Context object does not contain required field {}'.format(item))

            setattr(self, item, getattr(context, item))

    def as_dict(self):
        return {
            item: getattr(self, item)
            for item in self.__slots__
        }
