import os.path

from sandbox import sdk2

from sandbox.projects.yabs.qa.utils.resource import get_last_released_resource
from sandbox.projects.yabs.qa.resource_types import YABS_SERVER_BASE_PACK_EXECUTABLE


class TransportPack(object):

    thread_count = 32

    @classmethod
    def get_executable(cls):
        try:
            return cls._executable
        except AttributeError:
            res = get_last_released_resource(YABS_SERVER_BASE_PACK_EXECUTABLE)
            res_path = str(sdk2.ResourceData(res).path)
            cls._executable = os.path.join(res_path, 'transport')
        return cls._executable

    def compress_cmd(self):
        return "%s compress {src} {dst}.zstd_7 %d && mv {dst}.zstd_7 {dst}" % (self.get_executable(), self.thread_count)

    def decompress_cmd(self):
        return "%s decompress {src} {dst}.unpacking %d && mv {dst}.unpacking {dst}" % (self.get_executable(), self.thread_count)
