import json
import logging
from sandbox.projects.common.yabs.cachedaemon import CacheDaemon, CacheDaemonStubSandboxNonIntegrated, SERVICES_BY_TYPE

logger = logging.getLogger(__name__)


class YabsCacheDaemonStubAdapter(object):
    def __init__(self, stub):
        if not isinstance(stub, CacheDaemon) and not isinstance(stub, CacheDaemonStubSandboxNonIntegrated):
            raise RuntimeError('YabsCacheDaemonAdapter used over non-cachedaemon-related object')
        self._stub = stub

    def get_provided_services(self):
        provided_services = {}
        for tag, port in self._stub.get_ports_by_tag().iteritems():
            provided_services.update(dict.fromkeys(SERVICES_BY_TYPE.get(tag, [tag]), port))
        logger.debug('Cachedaemon provided services: %s', json.dumps(provided_services, indent=2))
        return provided_services
