from sandbox.projects.yabs.qa.sut.utils import reserve_port

from base import YabsServerBase


class YabsNull(YabsServerBase):

    # TODO: make this thing write request log if needed
    #       ( null handler + logger_default can do this pretty well)
    def __init__(
        self,
        path_maker,
        task_instance=None,
        port=None,
        instance_suffix='',
        provided_services=None,
        provided_ext_tags=None,
    ):
        if not port:
            self.main_port, self._socket = reserve_port()
        else:
            self.main_port = port
        self.name = 'yabs-null-{}-{}'.format(self.main_port, instance_suffix)
        self.provided_services = provided_services or []

        config_path = path_maker.work('null_stub.conf')
        with open(config_path, 'w') as config:
            config.write(_CONFIG)

        super(YabsNull, self).__init__(
            path_maker=path_maker,
            task_instance=task_instance,
            config=config_path,
            testmode=None,
        )

    def _get_port(self):
        return self.main_port

    def _get_monitor2_port(self):
        return None

    def _get_listen_ports(self):
        return [self.main_port]

    def _get_env_updates(self):
        return {'port': self.main_port}

    def _get_env_paths(self):
        return {}

    def get_provided_services(self):
        return {service: self.main_port for service in self.provided_services}

    def get_provided_ext_tags(self):
        """ Exts covered by the null stub are not to be checked """
        return set(self.provided_services)


_CONFIG = """
scheduler_t main_scheduler = scheduler_simple_t {
    threads = 1
    event_buf_size = 1000
    timeout_prec = 1
}

logger_t phantom_logger = logger_file_t {
    filename = $phantom_log_file
    level = info
    scheduler = main_scheduler
}

logger = phantom_logger

io_t http_io = io_stream_ipv6_t {
    proto_t http_proto = proto_http_t {
        host_default = "yabs.yandex.ru"

        p3p_t default_p3p = p3p_t {
            compact_value = "NOI DEVa TAIa OUR BUS UNI STA"
        }

        p3p = default_p3p

        loggers = { }

        handler_t null_handler = handler_null_t { }

        request_limits = {
            line = 512K
            field_num = 128
            field = 32K
            entity = 100M
        }

        any_host = {
            path = {
                "/" : { handler = null_handler }
            }
        }
    }

    ibuf_size = 1K
    obuf_size = 1K
    reuse_addr = true
    listen_backlog = 60000
    proto = http_proto
    timeout = 5m
    keepalive = 5d
    #address = 0.0.0.0
    port = $port
    defer_accept = true
    cork = true
    multiaccept = true
    force_poll = 10
    remote_errors = debug

    scheduler = main_scheduler
}
"""
