from sandbox.projects.yabs.qa.sut.utils import reserve_port
from base import YabsServerBase


class YabsTurl(YabsServerBase):

    name = 'yabs-turl-unknown'

    def __init__(
        self,
        path_maker,
        shard,
        task_instance=None,
        backends=None,
        config_mode='',
        instance_suffix='',
        custom_env='',
        store_phantom_logs=(YabsServerBase.LOG_PHANTOM,),
    ):

        self.shard = shard
        self.name = 'yabs-turl' + shard
        self.listen_port, self.socket = reserve_port()

        self.backends = backends or []

        self.monitor_ports = []
        self.monitor_sockets = []
        for port, socket in [reserve_port() for i in range(4)]:
            self.monitor_ports.append(port)
            self.monitor_sockets.append(socket)

        super(YabsTurl, self).__init__(
            path_maker,
            task_instance=task_instance,
            config='yabs-turl',
            config_mode=config_mode,
            testmode='yabs-turl',
            instance_suffix=instance_suffix,
            args=['turl' + shard],
            custom_env=custom_env,
            ping_host='turl.yandex.ru',
            store_phantom_logs=store_phantom_logs,
        )

    def _get_port(self):
        return self.listen_port

    def _get_monitor2_port(self):
        return self.monitor_ports[1]

    def _get_listen_ports(self):
        return [self.listen_port] + self.monitor_ports[:3]  # FIXME-BSSERVER-13677: add scheduler_monitor_port to listen ports when review 1222227 is in oneshot spec

    def _get_env_updates(self):
        updates = {
            'port': self.listen_port,
            'monitor1_port': self.monitor_ports[0],
            'monitor2_port': self.monitor_ports[1],
            'monitor3_port': self.monitor_ports[2],
            'scheduler_monitor_port': self.monitor_ports[3],
            # FIXME thread counts are arbitrary
            'thrs_main': 6,
            'thrs_client': 6,
            'thrs_rank': 15,
            'thrs_code': 15,
            'thrs_rtb': 6
        }

        for backend in self.backends:
            for service, port in backend.get_provided_services().iteritems():
                updates['{}_port'.format(service)] = port

        return updates

    def _use_real_turl(self):
        # Make it so real turl is enabled via commit to
        # sandbox-testmode/yabs-turl
        return 'USE_REAL_TURL' in self.server_env

    def get_provided_services(self):
        return {'yabsut' + self.shard: self.listen_port} if self._use_real_turl() else {}

    def get_provided_ext_tags(self):
        return {'turl'} if self._use_real_turl() else set()

    def _get_env_paths(self):
        return {}
