from sandbox.projects.yabs.qa.server_interface import LocalServerModuleInterface
from sandbox.projects.yabs.qa.module_base import ModuleBase
from sandbox.sdk2.helpers import ProcessLog
from sandbox.projects.yabs.qa.sut.utils import reserve_port

import subprocess
import logging
import time


class SimpleServerModule(ModuleBase, LocalServerModuleInterface):
    """
    This is an example module encapsulating a simple HTTP server.
    To implement a module, one needs to inherit from ModuleBase (which implements a very simple constructor -
    the point here is to state that a module does explicitly require an adapter to function),
    and, possibly, from an interface abstract class (in this case, LocalServerModuleInterface)
    """
    def __init__(self, adapter):
        ModuleBase.__init__(self, adapter)
        """
        ModuleBase implements an adapter property that returns the very adapter object passed to __init__.
        Adapter objects encapsulate the interaction between the module and its environment.
        """
        self._port, self._socket = reserve_port()
        self._process = None

    def __enter__(self):
        logging.info('Starting simple server on port {port}'.format(port=self._port))
        """
        Note the self.adapter.* method calls in the expression below.
        These accessor methods must be provided by the adapter in order for it and this module be compatible.
        It's better to explicitly describe those methods in the interface class from which all the adapters to this module would inherit.
        Observe adapters/interface/__init__.py for an example.
        """
        command_line = [
            self.adapter.get_server_executable_path(),
            str(self._port),
            self.adapter.get_content_string()
        ]
        self._process_log_context = ProcessLog(self.adapter.task_instance, logger="simple_server")
        self._process_log_context.__enter__()
        self._process = subprocess.Popen(command_line, stdout=self._process_log_context.stdout, stderr=self._process_log_context.stderr)
        time.sleep(2)
        return self

    def __exit__(self, *args):
        logging.info('Shutting down simple server')
        self._process.kill()
        self._process.communicate()
        self._process_log_context.__exit__(*args)
        self._process = None
        self._process_log_context = None

    def get_port(self):
        if self._process:
            return self._port
        else:
            return None
