from abc import ABCMeta, abstractmethod


class SimpleServerAdapterInterface(object):
    """
    This is an interface for adapter objects compatible with SimpleServerModule.
    Namely, correctly implementing all of the below methods guarantees that a SimpleServerModule provided with this adapter will have all of the
    required parametrization to function properly.
    For an example of the implementation of an adapter designed to work with Sandbox, observe ../sandbox/__init__.py.
    """

    __metaclass__ = ABCMeta

    @abstractmethod
    def get_server_executable_path(self):
        pass

    @abstractmethod
    def get_content_string(self):
        pass
