from sandbox.projects.yabs.qa.sut.example.adapters.interface import SimpleServerAdapterInterface
from parameters import SimpleServerParameters
from sandbox.projects.yabs.qa.adapter_base.sandbox import SandboxAdapterBase
from sandbox.projects.yabs.qa.sut.example import SimpleServerModule


class SimpleServerSandboxAdapter(SimpleServerAdapterInterface, SandboxAdapterBase):
    """
    This is an adapter compatible with both SimpleServerModule (guaranteed by implementation of SimpleServerAdapterInterface)
    and Sandbox (provided by inheritance from SandboxAdapterBase).
    """
    def __init__(self, parameters, task_instance):
        """
        SandboxAdapterBase provides two properties - parameters and task_instance, both access corresponding objects provided by __init__.
        """
        SandboxAdapterBase.__init__(self, parameters, task_instance)

    def get_server_executable_path(self):
        """
        SandboxAdapterBase provides a sync_resource convenience method -
        it takes an sdk2.Resource object and returns a path to the synced resource on the local filesystem.
        It is recommended to use sync_resource for every time the Resource is provided by Sandbox parametrization.
        """
        return self.sync_resource(self.parameters.server_executable)

    def get_content_string(self):
        return self.parameters.content_string

    """
    SandboxAdapterBase also declares two abstract method that must be implemented -
    a static get_init_parameters_class that returns the sdk2.Parameters child that is compatible with this adapter,
    and a create_module that must return an initialized module which this adapter itself is compatible with.
    This way, when this code is used in a Sanbox task, it may look something like this:
        class Parameters(sdk2.Parameters):
            server_parameters = SimpleServerSandboxAdapter.get_init_parameters_class()()

            ...

        on_execute(self):
            server_adapter = SimpleServerSandboxAdapter(self.Parameters.server_parameters, self)
            server_module = server_adapter.create_module()

            ...

        ...and after that server_module is ready to be used.


    See ./parameters.py to see the parameters class definition
    and sandbox/projects/adfox/AdfoxExampleShootTask for an example task using this module.
    """
    @staticmethod
    def get_init_parameters_class():
        return SimpleServerParameters

    def create_module(self):
        return SimpleServerModule(self)
