import itertools

from sandbox.projects.yabs.qa.sut.metastat.sut_base import YabsServerSeparateSUTBase
from sandbox.projects.yabs.qa.sut.metastat.utils import init_meta, init_stat
from sandbox.projects.yabs.qa.sut.utils import ListContext


class YabsServerSeparateStatSUT(YabsServerSeparateSUTBase):

    def __init__(
        self,
        adapter,
        cachedaemon,
        stat_stub_ports=None,
        shard_no=0,  # 0 for meta, N > 0 for statN
        shared_base_state=None,
        maximum_keys_per_tag=10,
        use_sandbox_config=True,
        wait_ping_timeout=840,
        max_unpacking_workers=4,
        sync_resource_workers=8,
        yabs_server_bundle_path=None,
    ):
        YabsServerSeparateSUTBase.__init__(
            self,
            adapter,
            cachedaemon,
            shared_base_state,
            maximum_keys_per_tag,
            wait_ping_timeout,
            yabs_server_bundle_path,
        )

        self._shard_no = shard_no
        init_stat(self, use_sandbox_config, stat_stub_ports)

        self._is_stub = stat_stub_ports is not None
        if not self._is_stub:
            with ListContext(itertools.chain(self.get_instances(), [self._null_stub])):
                self._base_provider.provide(
                    itertools.chain(self.get_instances()),
                    sync_resource_workers=sync_resource_workers,
                    unpack_workers=max_unpacking_workers,
                )

    def is_stub(self):
        return self._is_stub

    def get_instances(self):
        return list(self._stats.values())

    def _get_server_iterable(self):
        server_iterable = [self._null_stub]
        if not self.is_stub():
            if self._shard_no == 0:
                server_iterable += self.get_instances()
            else:
                server_iterable += [self._stats[self._shard_no]]
        return server_iterable

    def _get_wait_ping_iterable(self):
        wait_ping_iterable = []
        if not self.is_stub():
            if self._shard_no == 0:
                wait_ping_iterable += self.get_instances()
            else:
                wait_ping_iterable += [self._stats[self._shard_no]]
        return wait_ping_iterable

    def get_server_backend_object(self):
        return self._stats[self._shard_no]

    def _get_backends_iter(self):
        return itertools.chain([self._null_stub, self._cachedaemon], self._stats.itervalues())


class YabsServerSeparateMetaSUT(YabsServerSeparateSUTBase):

    LINEAR_MODELS_WAIT_TIMEOUT_DEFAULT = YabsServerSeparateSUTBase.FACTORY_TYPE.LINEAR_MODELS_WAIT_TIMEOUT_DEFAULT

    def __init__(
        self,
        adapter,
        cachedaemon,
        stat_instances,
        shared_base_state=None,
        maximum_keys_per_tag=10,
        use_sandbox_config=True,
        wait_ping_timeout=840,
        linear_models_wait_timeout=LINEAR_MODELS_WAIT_TIMEOUT_DEFAULT,
        max_unpacking_workers=4,
        sync_resource_workers=8,
        yabs_server_bundle_path=None,
    ):
        YabsServerSeparateSUTBase.__init__(
            self,
            adapter,
            cachedaemon,
            shared_base_state,
            maximum_keys_per_tag,
            wait_ping_timeout,
            yabs_server_bundle_path,
        )

        init_meta(self, use_sandbox_config, linear_models_wait_timeout, [self._null_stub, self._cachedaemon_adapter] + stat_instances)

        meta_provided_services = [self._meta]
        no_need_provider = [self._null_stub]

        with ListContext(itertools.chain(meta_provided_services, no_need_provider)):
            self._base_provider.provide(
                meta_provided_services,
                sync_resource_workers=sync_resource_workers,
                unpack_workers=max_unpacking_workers,
            )

    def _get_server_iterable(self):
        server_iterable = [self._null_stub, self._meta]
        if self.adapter.parameters.use_separate_linear_models_service:
            server_iterable.append(self._linear_models_service)
        return server_iterable

    def _get_wait_ping_iterable(self):
        return [self._meta]

    def get_server_backend_object(self):
        return self._meta

    def _get_backends_iter(self):
        return itertools.chain([self._null_stub, self._meta, self._cachedaemon])
