from sandbox.projects.yabs.qa.sut.metastat import YabsServerSeparateStatSUT
from sandbox.projects.yabs.qa.sut.metastat.adapters.common import YabsSeparateAdapterBase, CLUSTER_CONFIG_PARAMETER, CLUSTER_TAG_CONFIG_PARAMETER


class YabsStatAdapter(YabsSeparateAdapterBase):
    def get_stat_shards(self):
        return list(self.parameters.stat_shards)

    def get_server_resource(self):
        return self.parameters.stat_server_resource

    def get_binary_base_resources(self):
        return self.parameters.stat_binary_base_resources

    def get_stat_store_access_log(self):
        return self.parameters.stat_store_access_log

    def get_stat_store_request_log(self):
        return self.parameters.stat_store_request_log

    def get_stat_custom_environment(self):
        dict_environment = {
            CLUSTER_CONFIG_PARAMETER: self.get_cluster_config(),
            CLUSTER_TAG_CONFIG_PARAMETER: self.get_cluster_tag(),
            'saas_static_topology_path': self.get_saas_frozen_topology()
        }
        dict_environment.update(self.parameters.stat_custom_environment)
        return self.dict_to_env(dict_environment)

    def create_module(self, *args, **kwargs):
        return YabsServerSeparateStatSUT(self, *args, **kwargs)
