from sandbox import sdk2
from sandbox.projects.resource_types import YANDEX_SURF_DATA
from sandbox.projects.yabs.qa.resource_types import (
    BS_RELEASE_TAR,
    YABS_SERVER_CACHE_DAEMON_STUB_DATA,
    YABS_SERVER_SAAS_FREEZE_DATA,
    YabsServerExtServiceEndpoint,
)
from sandbox.projects.websearch.begemot import resources as begemot_resources
from sandbox.projects.yabs.qa.tasks.YabsServerFreezeCurrentKvrsSaasSnapshot import YabsServerSaasTopology
from sandbox.projects.YabsLmService.resource_types import YABS_LINEAR_MODELS_EXECUTABLE


class YabsSUTParameters(sdk2.Task.Parameters):
    use_tmpfs = sdk2.parameters.Bool('Use tmpfs', default_value=True)
    meta_mode = sdk2.parameters.String('Meta mode', choices=[(x, x) for x in ['bs', 'yabs', 'bsrank']], default_value='bs')
    stat_shards = sdk2.parameters.JSON('List of stat shards', default_value=[5])
    surf_data_resource = sdk2.parameters.Resource('Resource with surf data', resource_type=YANDEX_SURF_DATA, default_value=121355487)
    cache_daemon_stub_resource = sdk2.parameters.Resource('Cache daemon stub', resource_type=YABS_SERVER_CACHE_DAEMON_STUB_DATA)
    use_packed_bases = sdk2.parameters.Bool('Use packed bases', default_value=False)
    specify_cluster_set_config = sdk2.parameters.Bool('Set `cluster_set_config` by meta_mode', default_value=True)
    specify_cluster_tag = sdk2.parameters.Bool('Set `cluster_tag` by meta_mode', default_value=True)
    saas_frozen_topology = sdk2.parameters.Resource('Resource with KVRS Saas frozen topology data', resource_type=YabsServerSaasTopology)


class YabsStatParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('Stat server module parameters') as stat_server_parameters:
        stat_server_resource = sdk2.parameters.Resource('Resource with yabs-server (stat)', resource_type=BS_RELEASE_TAR)
        stat_binary_base_resources = sdk2.parameters.JSON('Binary base list (stat)', default_value=[])
        stat_custom_environment = sdk2.parameters.JSON('Stat custom environment', default_value={})
        stat_store_access_log = sdk2.parameters.Bool('Store stat access log', default_value=True)
        stat_store_request_log = sdk2.parameters.Bool('Store stat request log', default_value=False)


class YabsMetaParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('Meta server module parameters') as meta_server_parameters:
        meta_server_resource = sdk2.parameters.Resource('Resource with yabs-server (meta)', resource_type=BS_RELEASE_TAR)
        meta_binary_base_resources = sdk2.parameters.JSON('Binary base list (meta)', default_value=[])
        meta_custom_environment = sdk2.parameters.JSON('Meta custom environment', default_value={})
        meta_store_access_log = sdk2.parameters.Bool('Store meta access log', default_value=True)
        meta_store_request_log = sdk2.parameters.Bool('Store meta request log', default_value=False)
        saas_freeze_data_resource = sdk2.parameters.Resource('Resource with Saas freeze data', resource_type=YABS_SERVER_SAAS_FREEZE_DATA)
        ext_service_endpoint_resources = sdk2.parameters.Resource('Resources with endpoint set of external services', resource_type=YabsServerExtServiceEndpoint, multiple=True)
        hamster_ext_service_tags = sdk2.parameters.JSON('List of hamster service_tags', default_value=[])

        use_separate_linear_models_service = sdk2.parameters.Bool('Use separate linear models service', default_value=False)
        # XXX: BSSERVER-17518 temporarily make parameters always available for tests
        # with use_separate_linear_models_service.value[True]:
        linear_models_binary_resource = sdk2.parameters.Resource('Linear models binary', resource_type=YABS_LINEAR_MODELS_EXECUTABLE)
        linear_models_data_resource = sdk2.parameters.Resource('Linear models data', resource_type=begemot_resources.BEGEMOT_REALTIME_PACKAGE)


class YabsSUTSecondParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('Second server module parameters') as second_server_parameters:
        use_tmpfs_2 = sdk2.parameters.Bool('Use tmpfs', default_value=True)
        meta_mode_2 = sdk2.parameters.String('Meta mode', choices=[(x, x) for x in ['bs', 'yabs', 'bsrank']], default_value='bs')
        stat_shards_2 = sdk2.parameters.JSON('List of stat shards', default_value=[5])
        surf_data_resource_2 = sdk2.parameters.Resource('Resource with surf data', resource_type=YANDEX_SURF_DATA, default_value=121355487)
        cache_daemon_stub_resource_2 = sdk2.parameters.Resource('Cache daemon stub', resource_type=YABS_SERVER_CACHE_DAEMON_STUB_DATA)
        use_packed_bases_2 = sdk2.parameters.Bool('Use packed bases', default_value=False)
        specify_cluster_set_config_2 = sdk2.parameters.Bool('Set `cluster_set_config` by meta_mode', default_value=False)
        specify_cluster_tag_2 = sdk2.parameters.Bool('Set `cluster_tag` by meta_mode', default_value=True)
        saas_frozen_topology_2 = sdk2.parameters.Resource('Resource with KVRS Saas frozen topology data', resource_type=YabsServerSaasTopology)


class YabsStatSecondParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('Stat server module parameters') as stat_server_parameters_2:
        stat_server_resource_2 = sdk2.parameters.Resource('Resource with yabs-server (stat)', resource_type=BS_RELEASE_TAR)
        stat_binary_base_resources_2 = sdk2.parameters.JSON('Binary base list (stat)', default_value=[])
        stat_custom_environment_2 = sdk2.parameters.JSON('Stat custom environment', default_value={})
        stat_store_access_log_2 = sdk2.parameters.Bool('Store stat access log', default_value=True)
        stat_store_request_log_2 = sdk2.parameters.Bool('Store stat request log', default_value=False)


class YabsMetaSecondParameters(sdk2.Task.Parameters):
    with sdk2.parameters.Group('Meta server module parameters') as meta_server_parameters_2:
        meta_server_resource_2 = sdk2.parameters.Resource('Resource with yabs-server (meta)', resource_type=BS_RELEASE_TAR)
        meta_binary_base_resources_2 = sdk2.parameters.JSON('Binary base list (meta)', default_value=[])
        meta_custom_environment_2 = sdk2.parameters.JSON('Meta custom environment', default_value={})
        meta_store_access_log_2 = sdk2.parameters.Bool('Store meta access log', default_value=True)
        meta_store_request_log_2 = sdk2.parameters.Bool('Store meta request log', default_value=False)
        saas_freeze_data_resource_2 = sdk2.parameters.Resource('Resource with Saas freeze data', resource_type=YABS_SERVER_SAAS_FREEZE_DATA)
        ext_service_endpoint_resources_2 = sdk2.parameters.Resource('Resources with endpoint set of external services', resource_type=YabsServerExtServiceEndpoint, multiple=True)
        hamster_ext_service_tags_2 = sdk2.parameters.JSON('List of hamster service_tags', default_value=[])


class YabsSUTParameters2On1(sdk2.Task.Parameters):
    yabs_server_module_parameters = YabsSUTParameters()
    yabs_server_module_second_parameters = YabsSUTSecondParameters()


class YabsMetaParameters2On1(sdk2.Task.Parameters):
    yabs_meta_parameters = YabsMetaParameters()
    yabs_meta_second_parameters = YabsMetaSecondParameters()


class YabsStatParameters2On1(sdk2.Task.Parameters):
    yabs_stat_parameters = YabsStatParameters()
    yabs_stat_second_parameters = YabsStatSecondParameters()
