import logging


def init_meta(module, use_sandbox_config, linear_models_wait_timeout, backends):
    logging.info("init_meta")
    if module.adapter.parameters.use_separate_linear_models_service:
        module._linear_models_service = module._factory.create_linear_models(
            module.adapter.get_linear_models_binary_resource_path(),
            module.adapter.get_linear_models_data_resource_path(),
            wait_timeout=linear_models_wait_timeout,
        )
        backends.append(module._linear_models_service)
    module._meta = module._factory.create_meta(
        backends=backends,
        custom_env=module.adapter.get_meta_custom_environment(),
        config_mode='sandbox' if use_sandbox_config else '',
        store_access_log=module.adapter.get_meta_store_access_log(),
        store_request_log=module.adapter.get_meta_store_request_log(),
        meta_mode=module.adapter.get_meta_mode(),
    )


def init_stat(module, use_sandbox_config, stat_stub_ports):
    logging.info("init_stat")
    module.stat_stub_ports = stat_stub_ports or {}
    logging.debug('Stat stub ports: %s', module.stat_stub_ports)
    module._stat_shards = module.adapter.get_stat_shards()
    module._stats = {
        shard: module._factory.create_stat(
            backends=[module._null_stub, module._cachedaemon_adapter],
            custom_env=module.adapter.get_stat_custom_environment(),
            config_mode='sandbox' if use_sandbox_config else '',
            store_access_log=module.adapter.get_stat_store_access_log(),
            shard='{:02}'.format(shard),
            log_requests=module.adapter.get_stat_store_request_log(),
            stat_stub_port=module.stat_stub_ports.get('yabstat{:02}'.format(shard)),
        ) for shard in module._stat_shards
    }
