import socket
import os
import sys

import six


def reserve_port():
    # Do not discard returned socket until the service binds to the port,
    # or it will be freed.
    sock = socket.socket(socket.AF_INET6)
    sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    sock.bind(('::', 0))
    port = sock.getsockname()[1]
    return port, sock


class ListContext:
    def __init__(self, item):
        self.item = list(item)

    def __enter__(self):
        for x in self.item:
            x.__enter__()
        return self.item

    def __exit__(self, exc_type, value, traceback):
        internal_exc_type, internal_exc_value, internal_traceback = None, None, None
        for x in reversed(self.item):
            try:
                x.__exit__(exc_type, value, traceback)
            except:
                internal_exc_type, internal_exc_value, internal_traceback = sys.exc_info()
        if internal_exc_type:
            six.reraise(internal_exc_type, internal_exc_value, internal_traceback)


class ChdirContext(object):
    def __init__(self, path):
        self._dest_wdir = path

    def __enter__(self):
        self._orig_wdir = os.getcwd()
        os.chdir(self._dest_wdir)

    def __exit__(self, *args):
        os.chdir(self._orig_wdir)
