from sandbox import sdk2


def factory(sut_module_adapter_class, ammo_module_adapter_class, shoot_module_adapter_class, dump_resource_class, name_postfix, yt_uploader_adapter_class=None):
    if yt_uploader_adapter_class:
        class TaskParameters(sdk2.Task.Parameters):
            sut_module_parameters = sut_module_adapter_class.get_init_parameters_class()()
            ammo_module_parameters = ammo_module_adapter_class.get_init_parameters_class()()
            shoot_module_parameters = shoot_module_adapter_class.get_init_parameters_class()()
            yt_upload = sdk2.parameters.Bool('Upload to YT', default=False)
            with yt_upload.value[True]:
                yt_uploader_module_parameters = yt_uploader_adapter_class.get_init_parameters_class()()
    else:
        class TaskParameters(sdk2.Task.Parameters):
            sut_module_parameters = sut_module_adapter_class.get_init_parameters_class()()
            ammo_module_parameters = ammo_module_adapter_class.get_init_parameters_class()()
            shoot_module_parameters = shoot_module_adapter_class.get_init_parameters_class()()

    class TaskClass(sdk2.Task):
        name = 'FACTORY_SIMPLE_SHOOT_{}'.format(name_postfix)

        Parameters = TaskParameters

        def on_execute(self):
            sut_service = sut_module_adapter_class(self.Parameters.sut_module_parameters, self).create_module()
            ammo_module = ammo_module_adapter_class(self.Parameters.ammo_module_parameters, self).create_module()
            shoot_module = shoot_module_adapter_class(self.Parameters.shoot_module_parameters, self).create_module()
            with sut_service as active_service:
                dump_path = shoot_module.shoot(active_service, ammo_module.get_dplan_path())
            dump_resource = dump_resource_class(self, 'Result resource', dump_path)
            if self.Parameters.yt_upload:
                yt_upload_module = yt_uploader_adapter_class(self.Parameters.yt_uploader_module_parameters, self).create_module()
                yt_path = yt_upload_module.upload_results(dump_path)
                dump_resource.yt_table_path = yt_path
                self.Context.output_yt_path = yt_path

    return TaskClass
