from sandbox import sdk2
from sandbox.common.types import task as ctt
from sandbox.projects.sandbox.sandbox_lxc_image import SandboxLxcImage, UbuntuRelease
from sandbox.projects.sandbox.sandbox_lxc_image.image import Image
from sandbox.projects.yabs.qa.resource_types import YabsMysqlLxcImage
from sandbox.projects.yabs.qa.tasks.YabsMysqlLxcImageAcceptance import YabsMysqlLxcImageAcceptance

CUSTOM_REPOS_PRECISE = [
    'deb http://dist.yandex.ru/system configs/all/',
    'deb http://bsdist.yandex.net/yabs-precise stable/all/',
    'deb http://bsdist.yandex.net/yabs-precise stable/amd64/',
    'deb http://yabs-precise.bsdist.yandex.net/yabs-precise unstable/all/',
    'deb http://yabs-precise.bsdist.yandex.net/yabs-precise unstable/amd64/',
    'deb http://yabs-precise.bsdist.yandex.net/yabs-precise testing/all/',
    'deb http://yabs-precise.bsdist.yandex.net/yabs-precise testing/amd64/',
]


BASE_PACKAGES = Image.BASE_PACKAGES + [
    'yabs-archive-keyring',
]


YABS_CUSTOM_PACKAGES = [
    'yabs-mysql-conf',
    'yabs-dbrestore',
    'experiment-switcher',
]


CUSTOM_PACKAGES = [
    'binutils',
    'yabs-archive-keyring',
    'yabs-deps-solver',
]


CUSTOM_SCRIPT = [
    'export PSEUDO_HOSTNAME=\'sandbox\'',
    'export ASSUME_YES=1',
    'if [ ! -f "/var/run/gosky.nocron" ]; then',
    '    > /var/run/gosky.nocron',
    'fi',
    'echo "host bsgm-sandbox-singlestat" > /etc/testing',
    'echo "yabs-mysql-grants-testing-host " > /etc/testing',
    'echo "dbrestore-bsbackup-conductor-group yabs_bsbackup@sas" > /etc/testing',
    'echo "@base-map bsdb:yabsdb local:yabsdb" > /etc/testing',
    'echo "@base-map bsdb:yabsinfo local:yabsinfo" > /etc/testing',
    'echo "@base-map bsdb.yandex.ru:yabsdb local:yabsdb" > /etc/testing',
    'echo "@base-map bsdb.yandex.ru:yabsinfo local:yabsinfo" > /etc/testing',
    'for d in /var/lib/mysql.yabs* /mnt/raid /tmp/dbrestore; do',
    '    if [[ -L $d && ! -e $d ]]; then',
    '        rm $d;',
    '    fi;',
    'done',
    'echo \'yabs-rsync-conf hold\' | dpkg --set-selections',
    'resolved_packages=$(yabs-deps-solver {})'.format(' '.join(YABS_CUSTOM_PACKAGES)),
    'DEBIAN_FRONTEND=noninteractive ASSUME_YES=1 PATH=/root/sbin:$PATH apt-get update --assume-yes --force-yes',
    'DEBIAN_FRONTEND=noninteractive ASSUME_YES=1 PATH=/root/sbin:$PATH apt-get install $resolved_packages'
        ' -q0 --assume-yes --force-yes -o Acquire::ForceIPv6=true -o Dpkg::Options::=\'--force-confdef\'',
    'telinit 2',
    '/etc/init.d/mysql.yabs stop',
    'chmod -Rf a+rw /var/lib/mysql.*/ /var/log/yabs*',
    '/etc/init.d/mysql.yabs yabs start',
]


class CreateYabsMysqlLxcImage(SandboxLxcImage):
    name = "CREATE_YABS_MYSQL_LXC_IMAGE"

    class Parameters(SandboxLxcImage.Parameters):
        resource_type = SandboxLxcImage.Parameters.resource_type(default=YabsMysqlLxcImage.name)
        resource_description = SandboxLxcImage.Parameters.resource_description(default='LXC image with yabs mysql, dbrestore and experiment-switcher installed')
        custom_image = SandboxLxcImage.Parameters.custom_image(default=True)
        ubuntu_release = SandboxLxcImage.Parameters.ubuntu_release(default=UbuntuRelease.PRECISE)
        custom_script = SandboxLxcImage.Parameters.custom_script(default='\n'.join(CUSTOM_SCRIPT))
        custom_repos = SandboxLxcImage.Parameters.custom_repos(default='\n'.join(CUSTOM_REPOS_PRECISE))
        base_packages = SandboxLxcImage.Parameters.base_packages(default=' '.join(BASE_PACKAGES))
        custom_packages = SandboxLxcImage.Parameters.custom_packages(default=' '.join(CUSTOM_PACKAGES))

    def cook_image(self, current_dir):
        super(CreateYabsMysqlLxcImage, self).cook_image(current_dir)

    def run_tests(self):
        for privileged in (True, False):
            task = YabsMysqlLxcImageAcceptance(
                self,
                description="Test LXC image #{}".format(self.Context.container_id),
                lxc_resource=self.Context.container_id,
                privileged=privileged
            )
            task.Requirements.disk_space = self.Requirements.disk_space
            self.Context.children.append(task.save().enqueue().id)

        raise sdk2.WaitTask(self.Context.children, ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True)
