from sandbox import sdk2

from sandbox.projects.common.yabs.server.tracing import TRACE_WRITER_FACTORY
from sandbox.projects.yabs.sandbox_task_tracing import trace_entry_point


class DoNothing(sdk2.Task):
    """Task which does nothing"""

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 512

        class Caches(sdk2.Requirements.Caches):
            pass  # Do not use any shared caches (required for running on multislot agent)

    @trace_entry_point(writer_factory=TRACE_WRITER_FACTORY)
    def on_execute(self):
        pass
