import logging
from sandbox.projects.yabs.qa.tasks.YabsServerB2BFuncShootCmp.utils.report_utils import ELogChange, ELogFieldChange

logger = logging.getLogger(__name__)


def need_autoresolve(smart_report, allowed_changes):
    diff_changes = []
    for log_change_type in (ELogChange.added_logs, ELogChange.removed_logs):
        changes = smart_report['diff_blocks_detailed']['logs_data'][log_change_type.name]
        if changes and not allowed_changes.get(log_change_type.name, False):
            logger.info('Diff has %s: %s', log_change_type.name, changes)
            return False, diff_changes
        elif changes:
            diff_changes.append('{}: {}'.format(log_change_type.name, ', '.join(changes)))

    for log, log_changes in smart_report['diff_blocks_detailed']['logs_data'][ELogChange.changed_logs.name].items():
        for field_change_type in (ELogFieldChange.added_fields, ELogFieldChange.removed_fields, ELogFieldChange.changed_fields):
            changes = log_changes.get(field_change_type.name, [])
            if changes and not allowed_changes.get(ELogChange.changed_logs.name, {}).get(field_change_type.name, False):
                logger.info('Diff has %s in %s: %s', field_change_type.name, log, changes)
                return False, diff_changes
            elif changes:
                diff_changes.append('{} {}: {}'.format(log, field_change_type.name, ', '.join(changes)))

    return True and len(diff_changes) > 0, diff_changes
