from sandbox import sdk2
from sandbox.common.types.notification import Transport
from sandbox.sandboxsdk import environments

from sandbox.projects.yabs.qa.solomon.mixin import SolomonTaskMixin, SolomonTaskMixinParameters
from sandbox.projects.yabs.qa.clickhouse.http_client import ClickhouseHttpClient
from sandbox.projects.yabs.qa.tasks.YabsCollectPrecommitChecks.precommit_check_tasks import get_precommit_checks_sensors

PRECOMMIT_CHECKS_SERVICE = 'check_duration'
TASK_OWNERS = (
    'YABS_SERVER_SANDBOX_TESTS',
)


class YabsCollectPrecommitChecks(SolomonTaskMixin, sdk2.Task):
    """
    Collect precommit checks info
    """

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024
        disk_space = 100

        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet', use_wheel=True),
        )

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_create(self):
        super(YabsCollectPrecommitChecks, self).on_create()
        if self.Context.copy_of:
            self.Parameters.notifications = [
                notification for notification in self.Parameters.notifications
                if notification.transport != Transport.JUGGLER
            ]

    class Parameters(SolomonTaskMixinParameters):

        days_window = sdk2.parameters.Integer('Statistics window in days', default=7)

    def on_execute(self):
        clickhouse_client = ClickhouseHttpClient(host='clickhouse-sandbox.n.yandex-team.ru', port=443)
        precommit_checks_sensors_data = get_precommit_checks_sensors(clickhouse_client, owners=TASK_OWNERS,
                                                                     days=self.Parameters.days_window)
        self.solomon_push_client.add(precommit_checks_sensors_data, service=PRECOMMIT_CHECKS_SERVICE)
