SELECT quantiles({% for quantile in quantiles %}{{ quantile }}{% if not loop.last %},{% endif %}{% endfor %})(stage_duration) as stage_duration_quantiles
FROM (
    SELECT max(history.finish) - min(history.start) as stage_duration
    FROM (
        SELECT task_id, hints[1] as hint
        FROM sandbox.taskcreationd
        WHERE has(tags, 'TESTENV-PRECOMMIT-CHECK')
        AND hasAny(tags, [{% for tag in tags -%}'{{ tag }}'{% if not loop.last %},{% endif %}{% endfor -%}])
        AND notEmpty(hints)
        AND author = 'robot-testenv'
        AND owner in ({% for owner in owners %}'{{ owner }}'{% if not loop.last %},{% endif %}{% endfor %})
        AND task_type in ({% for task_type in task_types %}'{{ task_type }}'{% if not loop.last %},{% endif %}{% endfor %})
        AND timestamp >= today() - {{ days_window }}
    ) as creation
    INNER JOIN (
        SELECT task_id, min(timestamp) as start, max(timestamp) as finish
        FROM sandbox.auditd
        WHERE timestamp >= today() - {{ days_window }}
        GROUP BY task_id
    ) as history
    USING task_id
    GROUP BY hint
)
