SELECT status, task_type, quantiles({% for quantile in quantiles %}{{ quantile }}{% if not loop.last %},{% endif %}{% endfor %})(duration) as status_duration_quantiles
FROM (
    SELECT task_id, status, task_type, sum(duration) as duration
    FROM (
        SELECT task_id, task_type
        FROM sandbox.taskcreationd
        WHERE hasAny(tags, [{% for tag in tags -%}'{{ tag }}'{% if not loop.last %},{% endif %}{% endfor -%}])
        AND has(tags, 'TESTENV-PRECOMMIT-CHECK')
        AND notEmpty(hints)
        AND author = 'robot-testenv'
        AND owner in ({% for owner in owners %}'{{ owner }}'{% if not loop.last %},{% endif %}{% endfor %})
        AND task_type in ({% for task_type in task_types %}'{{ task_type }}'{% if not loop.last %},{% endif %}{% endfor %})
        AND timestamp >= today() - {{ days_window }}
    ) as creation
    INNER JOIN (
        SELECT task_id, status, -sum(durations) as duration
        FROM (
            SELECT task_id, status, runningDifference(toInt64(timestamp)) as durations
            FROM (
                SELECT task_id, status, timestamp
                FROM sandbox.auditd
                WHERE timestamp >= today() - {{ days_window }}
                ORDER BY task_id, timestamp DESC
            )
        )
        WHERE status in ({% for status in statuses %}'{{ status }}'{% if not loop.last %},{% endif %}{% endfor %})
        GROUP BY task_id, status
    ) as history
    USING task_id
    GROUP BY task_id, status, task_type
)
GROUP BY status, task_type
