YABS_RAM_REQUIREMENT_GB = 180


class ClusterMap(object):
    @staticmethod
    def check_common(host_data):
        return True

    @staticmethod
    def check_ssd(host_data):
        return 'SSD' in host_data['tags']

    @staticmethod
    def check_no_ssd(host_data):
        return 'SSD' not in host_data['tags']

    @staticmethod
    def check_bigram(host_data):
        return host_data['ram'] >= YABS_RAM_REQUIREMENT_GB * 1 << 30

    @staticmethod
    def check_no_bigram(host_data):
        return host_data['ram'] < YABS_RAM_REQUIREMENT_GB * 1 << 30

    __cluster_map = {
        'sandbox_pool': check_common.__func__,
        'sandbox_pool_ssd': check_ssd.__func__,
        'sandbox_pool_no_ssd': check_no_ssd.__func__,
        'sandbox_pool_bigram': check_bigram.__func__,
        'sandbox_pool_no_bigram': check_no_bigram.__func__
    }

    @classmethod
    def get_clusters(cls, host_data):
        cluster_list = []
        for cluster, check_method in cls.__cluster_map.iteritems():
            if check_method(host_data):
                cluster_list.append(cluster)
        return cluster_list
