import logging

from jinja2 import Environment


logger = logging.getLogger(__name__)


DESCRIPTION_TEMPLATE = '''
Resource {% if broken_tasks -%}check [{{ check }}](https://testenv.yandex-team.ru/?screen=timeline&database={{ check }}){% else %}switching{% endif %} has failed
{%- if broken_tasks %} due to failure of the following tasks:
{% for broken_task in broken_tasks -%}
https://sandbox.yandex-team.ru/task/{{ broken_task }}/view
{% endfor -%}
{% else -%}
, please, check [bste](https://bste.in.yandex-team.ru/) for new failures in switching.
{% endif %}
Resources:
{% for resource in resources -%}
[{{ resource.name }} #{{ resource.id}}](https://sandbox.yandex-team.ru/resource/{{ resource.id }}/view)
{% endfor %}
'''.lstrip('\n')


def issue_description(check, broken_tasks, resources):
    env = Environment()
    template = env.from_string(DESCRIPTION_TEMPLATE)
    return template.render(check=check, broken_tasks=broken_tasks, resources=resources)


def issue_summary(broken_tasks, resources):
    resource_names = [resource.name for resource in resources]
    if 'YABS_CS_INPUT_SPEC' in [resource.name for resource in resources]:
        tier = 'data and ammo'
    else:
        tier = ', '.join(resource_names)

    return 'New {tier} resources {process} failed'.format(
        tier=tier,
        process='check' if broken_tasks else 'switching',
    )


def create_issue_if_needed(startrek_client, check, broken_tasks, resources, queue):
    summary = issue_summary(broken_tasks, resources)
    description = issue_description(check, broken_tasks, resources)

    logger.debug('Summary: %s', summary)
    logger.debug('Description: %s', description)

    issue_tags = [
        "new_resources",
        "__auto_created",
        check,
    ]
    search_query = " AND ".join([
        "Tags: {}".format(tag) for tag in issue_tags
    ] + [
        "Queue: {}".format(queue),
    ])
    created_issues = list(startrek_client.issues.find(search_query))
    if created_issues:
        logger.debug('Issue %s was already created', created_issues[0])
        return

    startrek_client.issues.create(
        queue=queue,
        summary=summary,
        description=description,
        tags=issue_tags,
    )
