import logging

from sandbox import sdk2
from sandbox.projects.websearch.begemot import resources as begemot_resources
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.sandbox import DolbiloModuleSandboxAdapter
from sandbox.projects.yabs.qa.dumper_module.adapters.sandbox import DumperModuleSandboxAdapter
from sandbox.projects.YabsLmService.resource_types import YABS_LINEAR_MODELS_EXECUTABLE
from sandbox.projects.yabs.qa.sut.components import linear_models


class YabsLinearModelsShoot(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        kill_timeout = 900  # 15 min
        binary = sdk2.parameters.Resource("Yabs linear models binary", resource_type=YABS_LINEAR_MODELS_EXECUTABLE)
        data = sdk2.parameters.Resource(
            "Yabs linear models data",
            resource_type=begemot_resources.BEGEMOT_REALTIME_PACKAGE,
            required=True,
        )
        plan = sdk2.parameters.Resource("Plan for dolbilo to shoot", default_value=1813498122)
        with sdk2.parameters.Group('Shoot module settings') as shoot_module_settings:
            shoot_module_parameters = DolbiloModuleSandboxAdapter.get_init_parameters_class()()
        with sdk2.parameters.Group('Dumper module settings') as dumper_module_settings:
            dumper_module_parameters = DumperModuleSandboxAdapter.get_init_parameters_class()()

    def on_execute(self):
        shoot_adapter = DolbiloModuleSandboxAdapter(self.Parameters.shoot_module_parameters, self)
        shoot_module = shoot_adapter.create_module()
        with linear_models.YabsLinearModels(
            self,
            str(sdk2.ResourceData(self.Parameters.binary).path),
            str(sdk2.ResourceData(self.Parameters.data).path),
        ) as ylm:
            dump_path = shoot_module.shoot(
                ylm,
                sdk2.ResourceData(sdk2.Resource[self.Parameters.plan]).path,
                no_body_encoding=False,
            )
            ylm.verify_stderr()
        dumper_module = DumperModuleSandboxAdapter(self.Parameters.dumper_module_parameters, self).create_module()
        logging.info("Dumper stats:\n%s", dumper_module.get_stats(dump_path))
