import logging

from sandbox import sdk2
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.sandbox.sandbox_lxc_image_acceptance import SandboxLxcImageAcceptance

CONNECTION_PARAMS = {
    'unix_socket': '/run/mysqld.yabs/mysqld.sock',
    'db': 'yabsdb',
    'user': 'root',
}

RPLCAT_CONNECTION_PARAMS = {
    'unix_socket': '/run/mysqld.yabs/mysqld.sock',
    'db': 'yabsdb',
    'user': 'rplcat',
    'passwd': 'slvrkng',
}

TEST_QUERY = 'SELECT 1'


class YabsMysqlLxcImageAcceptance(SandboxLxcImageAcceptance):
    class Requirements(sdk2.Task.Requirements):
        environments = (
            PipEnvironment('MySQL-python', '1.2.5', use_wheel=True),
        )

    def test_connection(**params):
        import MySQLdb
        connection = MySQLdb.connect(**params)
        cursor = connection.cursor()
        cursor.execute(TEST_QUERY)
        cursor.fetchall()
        cursor.close()
        connection.close()

    def on_execute(self):
        super(YabsMysqlLxcImageAcceptance, self).on_execute()

        if not self.Parameters.privileged:
            logging.info('Task running in unpriveleged container. Skipping extra tests')
            return

        logging.info('Running extra yabs mysql test')
        logging.info('Starting mysql.yabs...')
        run_process(['/etc/init.d/mysql.yabs', 'yabs', 'start'], log_prefix='mysql.yabs_start')
        logging.info('Running elementary databse query under root...')
        self.test_connection(**CONNECTION_PARAMS)
        logging.info('Finished extra yabs mysql test under root')
        logging.info('Running elementary databse query under rplcat...')
        self.test_connection(**RPLCAT_CONNECTION_PARAMS)
        logging.info('Finished extra yabs mysql test under rplcat')
