from copy import deepcopy


BASE64_CHAR_CHOICE_PATTERN = "[a-zA-Z0-9-_+/=,]"
BASE64_MATCH_PATTERN = BASE64_CHAR_CHOICE_PATTERN + '*'

DEFAULT_USER_SUBSTITUTES_JSON = {
    r"Last-Modified: ?\w+, ?\d{1,2}-\w+-\d{4} ?\d{2}:\d{2}:\d{2} GMT": "Last-Modified: <PAINTED>",
    r"reqid(?:=|%3D)[0-9]*": "reqid=<PAINTED>",
    r"yclid(?:=|%3D)[0-9]*": "yclid=<PAINTED>",
    r"\"cid\"\\s*:\\s*\"\\d+\"": "\"cid\":\"<PAINTED>\"",
    r"'rtb.async\\d+'": "'rtb.async<PAINTED>'",
    r"Expires: ?\w+, ?\d{1,2}-\w+-\d{4} ?\d{2}:\d{2}:\d{2} GMT": "Expires: <PAINTED>",
    r"click(_?)id=[0-9]+": "clickid=<PAINTED>",
    r"(aff_sub\\d?)=\\d+": "\\1=<PAINTED>",
    r"publisher_ref_id=\\d+": "publisher_ref_id=<PAINTED>",
    r"logid=\\d+": "logid=<PAINTED>",
    r"(\"seatbid\"\\s*:\\s*\\[\\s*\\{.*?\"bid\"\\s*:\\s*\\[\\s*\\{.*?\\s*\"id\"\\s*:\\s*)\"[0-9]+\"": "\\1\"<PAINTED>\"",
    r"expires=\w+, ?\d{1,2}-\w+-\d{4} ?\d{2}:\d{2}:\d{2} GMT": "expires=<PAINTED>",
    r"\"bid\":(\\s*)\\[\\{\n(\\s*)\"id\"(\\s*):(\\s*)\"[0-9]+\"": "\"bid\":\\1\\[\\{\n\\2\"id\"\\3:\\4\"<PAINTED>\"",
    r"<vmap:Extension\\s+type=\"SessionID\">(\\d)+</vmap:Extension>": "<vmap:Extension type=\"SessionID\">PAINTED</vmap:Extension>",
    r"<SessionID>[0-9]+</SessionID>": "<SessionID><PAINTED></SessionID>",
    r"\"id\"\\s*:\\s*\"\\d+\"": "\"id\":\"<PAINTED>\"",
    r"_1lpb_clickId=[0-9]*": "_1lpb_clickId=<PAINTED>",
    r"yandexuid=[0-9]*": "yandexuid=<PAINTED>",
    r"set-yp-user-bans=\\d*": "set-yp-user-bans=<PAINTED>",
    r"ban(?:n?)erid=([0-9]*):[0-9]*": "bannerid=\\1:<PAINTED>",
    r"\"bannerid\" ?:(?: ?)\"([0-9]*):[0-9]*": "\"bannerid\": \"\\1:<PAINTED>",
    r"subid4=[\\d]+": "subid4=<PAINTED>",
    r"YandexDirectInt_\\d+": "YandexDirectInt_<PAINTED>",
}

DEFAULT_BASE64_CAPTURE_JSON = {
    '\"iurl\":\\s*\"[^\"#]*#(' + BASE64_MATCH_PATTERN + ')': 1,
    '\\\\\"?html\\\\\"?:\\s*\\\\\"(' + BASE64_MATCH_PATTERN + ')\\\\\"': 1,
}

DEFAULT_IGNORED_RECORD_FIELDS_SET = set([
    'InternalHitRequestIDLo',
    'InternalHitRequestIDHi',
])

DEFAULT_IGNORED_RECORD_FIELDS_STR = ','.join(DEFAULT_IGNORED_RECORD_FIELDS_SET)

DEFAULT_IGNORED_LOG_FIELDS = [
    'BackendTime',
    'BidID',
    'CachedLogID',
    'EncryptedUniqID',
    'EventTime',
    'FrontendTime',
    'GraphID',
    'LogID',
    'MatchTime',
    'QueryArgs',
    'RealTime',
    'RedirURL',
    'RequestID',
    'ResponseID',
    'Timestamp',
    'TotalHitTime',
    'TotalTime',
    'access_stat:*',
    'dsp_object:Data',
    'dsp_response:Data',
    'ext_stat:*',
    'lock_stat:*',
    'lua_error:Detail',
    'news_event:HitTime',
    'redir:ReplyHeader',
    'request:*',
    'rtb:TotalRTBTime',
    'ssp_response:ADM',
    'field_validation:RowData',
    'ads_adfox:AdfoxRequestID',
    'ads_adfox:RequestTimeUsec',
    'ads_adfox_task:DurationUsec'
]

DEFAULT_IGNORED_LOG_FIELDS_STR = ','.join(DEFAULT_IGNORED_LOG_FIELDS)

DEFAULT_IGNORED_LOG_FIELDS_SET = set(DEFAULT_IGNORED_LOG_FIELDS)

LOG_TRANSFORMATION = {
    "request": {
        "*": {
            "action": {"type": "del"}
        }
    },
    "ext_stat": {
        "*": {
            "action": {"type": "del"}
        }
    },
    "access_stat": {
        "*": {
            "action": {"type": "del"}
        }
    },
    "lock_stat": {
        "*": {
            "action": {"type": "del"}
        }
    },
    "stage_timings": {
        "DurationMicroseconds": {
            "action": {"type": "del"}
        }
    },
    "dsp_response": {
        "Data": {
            "action": {"type": "paint_non_default"}
        }
    },
    "rtb": {
        "TotalRTBTime": {
            "action": {"type": "del"}
        }
    },
    "lua_error": {
        "Detail": {
            "action": {"type": "paint_non_default"}
        }
    },
    "news_event": {
        "HitTime": {
            "action": {"type": "del"}
        }
    },
    "redir": {
        "ReplyHeader": {
            "action": {"type": "paint_non_default"}
        }
    },
    "dsp_object": {
        "Data": {
            "action": {"type": "paint_non_default"}
        }
    },
    "ssp_response": {
        "ADM": {
            "action": {"type": "paint_non_default"}
        }
    },
    "ads_adfox": {
        "AdfoxRequestID": {
            "action": {"type": "paint_non_default"}
        },
        "RequestTimeUsec": {
            "action": {"type": "del"}
        }
    },
    "ads_adfox_task": {
        "DurationUsec": {
            "action": {"type": "del"}
        }
    },
    "wide": {
        "LogTimestamp": {
            "action": {"type": "paint_non_default"}
        }
    },
    "factors": {
        "LogTimestamp": {
            "action": {"type": "paint_non_default"}
        }
    },
    "field_validation": {
        "RowData": {
            "action": {"type": "paint_non_default"}
        },
        "GraphNode": {
            "action": {"type": "paint_non_default"}
        }
    },
    "vmap": {
        "VmapRequestID": {
            "action": {"type": "paint_non_default"}
        }
    },
    "verify": {  # TODO: igorock@ remove after handler fix
        "ServerTimestamp": {
            "action": {"type": "paint_non_default"}
        },
        "ID": {
            "action": {"type": "paint_non_default"}
        }
    },
    "hit": {
        "PageDegradationMultiplier": {
            "action": {"type": "paint_non_default"}
        },
        "SelectFeatureTotalTime": {
            "action": {"type": "del"}
        },
        "SelectFeatureMaxTime": {
            "action": {"type": "del"}
        },
        "MatchedContentCategories": {
            "action": {"type": "del"}
        },
        "ExperimentSettings": {
            "action": {"type": "del"}
        },
        "CpuTimeMeta": {
            "action": {"type": "del"}
        },
    },
    "prefetch_hit": {
        "ExperimentSettings": {
            "action": {"type": "del"}
        },
        "CpuTimeMeta": {
            "action": {"type": "del"}
        },
    },
    "click_hit": {
        "CpuTimeMeta": {
            "action": {"type": "del"}
        },
    },
    "wide_banner_text": {
        "BannerUrl": {
            "action": {"type": "del"}
        },
        "BannerURL": {
            "action": {"type": "del"}
        }
    },
    "factors_banner_text": {
        "BannerUrl": {
            "action": {"type": "del"}
        },
        "BannerURL": {
            "action": {"type": "del"}
        }
    },
    "*": {
        "BackendTime": {
            "action": {"type": "del"}
        },
        "TotalTime": {
            "action": {"type": "del"}
        },
        "RedirURL": {
            "action": {"type": "paint_non_default"}
        },
        "CachedLogID": {
            "action": {"type": "paint_non_default"}
        },
        "RealTime": {
            "action": {"type": "del"}
        },
        "Timestamp": {
            "action": {"type": "paint_non_default"}
        },
        "TotalHitTime": {
            "action": {"type": "del"}
        },
        "BidID": {
            "action": {"type": "paint_non_default"}
        },
        "ResponseID": {
            "action": {"type": "paint_non_default"}
        },
        "EventTime": {
            "action": {"type": "paint_non_default"}
        },
        "LogID": {
            "action": {"type": "paint_non_default"}
        },
        "MatchTime": {
            "action": {"type": "del"}
        },
        "RequestID": {
            "action": {"type": "paint_non_default"}
        },
        "GraphID": {
            "action": {"type": "paint_non_default"}
        },
        "ExtReqGraphNode": {
            "action": {"type": "paint_non_default"}
        },
        "EncryptedUniqID": {
            "action": {"type": "paint_non_default"}
        },
        "FrontendTime": {
            "action": {"type": "del"}
        },
        "ExtWaitingTime": {
            "action": {"type": "del"}
        },
        "PictureHash": {
            "action": {"type": "paint_non_default"}  # TODO: remove BSSERVER-15107
        },
        "RecordCreationTime": {
            "action": {"type": "paint_non_default"}
        },
        "BscountAvgResponseTime": {
            "action": {"type": "del"}
        },
    },
    "base_mtime": {
        "BaseName": {
            "action": {
                "type": "paint_non_default"
            }
        },
        "MTime": {
            "action": {
                "type": "paint_non_default"
            }
        }
    },
    "hit_redir": {
        "ExtResponseTime": {
            "action": {
                "type": "del"
            }
        },
    },
    "candidates": {
        "ClickometerDump": {
            "action": {
                "type": "del"
            }
        }
    },
    "hit_rt": {
        "HitContext.MatchTime": {
            "action": {"type": "del"}
        },
        "HitContext.ExtWaitingTime": {
            "action": {"type": "del"}
        },
        "HitContext.TotalTime": {
            "action": {"type": "del"}
        },
        "HitContext.PageDegradationMultiplier": {
            "action": {"type": "paint_non_default"}
        },
        "HitContext.SelectFeatureTotalTime": {
            "action": {"type": "del"}
        },
        "HitContext.SelectFeatureMaxTime": {
            "action": {"type": "del"}
        },
        "HitContext.MatchedContentCategories": {
            "action": {"type": "del"}
        },
        "HitContext.ExperimentSettings": {
            "action": {"type": "del"}
        },
        "HitContext.TotalHitTime": {
            "action": {"type": "paint_non_default"}
        },
        "HitContext.CpuTimeMeta": {
            "action": {"type": "del"}
        },
        "HitContext.BscountAvgResponseTime": {
            "action": {"type": "del"}
        },
    },
    "hit_batch": {
        "HitContext.MatchTime": {
            "action": {"type": "del"}
        },
        "HitContext.ExtWaitingTime": {
            "action": {"type": "del"}
        },
        "HitContext.TotalTime": {
            "action": {"type": "del"}
        },
        "HitContext.PageDegradationMultiplier": {
            "action": {"type": "paint_non_default"}
        },
        "HitContext.SelectFeatureTotalTime": {
            "action": {"type": "del"}
        },
        "HitContext.SelectFeatureMaxTime": {
            "action": {"type": "del"}
        },
        "HitContext.MatchedContentCategories": {
            "action": {"type": "del"}
        },
        "HitContext.ExperimentSettings": {
            "action": {"type": "del"}
        },
        "HitContext.TotalHitTime": {
            "action": {"type": "paint_non_default"}
        },
        "HitContext.CpuTimeMeta": {
            "action": {"type": "del"}
        },
        "HitContext.BscountAvgResponseTime": {
            "action": {"type": "del"}
        },
    },
}
# additional transformations for YabsServerABExperimentTest tasks
AB_LOG_TRANSFORMATION = deepcopy(LOG_TRANSFORMATION)
for field in ("ActiveTestIds", "YandexExpBoxes"):
    AB_LOG_TRANSFORMATION["*"][field] = {"action": {"type": "del"}}
    for _log in ("hit_rt", "hit_batch"):
        AB_LOG_TRANSFORMATION[_log]["HitContext.{}".format(field)] = {"action": {"type": "del"}}

AB_LOG_TRANSFORMATION["vmap"]["UriData"] = {"action": {"type": "del"}}

RESPONSE_TRANSFORMATION = {
    "*": [
        ["click_?id(=|%3D)\\d+", "clickid=<PAINTED>"],
        ["clickId(=|%3D)\\d+", "clickId=<PAINTED>"],  # https://st.yandex-team.ru/SHMDUTY-285
        ["yclid(=|%3D)\\d*", "yclid=<PAINTED>"],
        ["reqid(=|%3D)\\d*", "reqid=<PAINTED>"],
        ["logid=\\d*", "logid=<PAINTED>"],
        ["LOGID=\\d*", "LOGID=<PAINTED>"],
        ["regid=\\d*", "regid=<PAINTED>"],
        ["bann?erid=(\\d*):\\d*", "bannerid=\\1:<PAINTED>"],
        ["subid4=\\d+", "subid4=<PAINTED>"],
        ["_1lpb_clickId=\\d*", "_1lpb_clickId=<PAINTED>"],
        ["&dp=\\d*", "&dp=<PAINTED>"],
        ["YandexDirectInt_\\d+", "YandexDirectInt_<PAINTED>"],
    ],
    "no_redirect_url": [
        ["&dp=\\d*", "&dp=<PAINTED>"],
    ],
    "direct_url": [
        ["&dp=\\d*", "&dp=<PAINTED>"],
    ],
    "target_url": [
        ["&cl=\\d*", "&cl=<PAINTED>"],
        ["&dp=\\d*", "&dp=<PAINTED>"],
    ],
    "targetUrl": [
        ["&cl=\\d*", "&cl=<PAINTED>"],
        ["&dp=\\d*", "&dp=<PAINTED>"],
    ],
    "cid": [
        ["^\\d+$", "<PAINTED>"],
    ],
    "adm": [
        ["'rtb.async\\d+'", "'rtb.async<PAINTED>'"],
    ],
    "abuseUrl": [
        ["set-yp-user-bans=\\d*", "set-yp-user-bans=<PAINTED>"],
    ],
    "Set-Cookie": [
        ["expires=.+?GMT", "expires=<PAINTED>"],
        ["yandexuid=\\d*", "yandexuid=<PAINTED>"],
    ],
    "Expires": [
        [".+?GMT", "<PAINTED>"],
    ],
    "Last-Modified": [
        [".+?GMT", "<PAINTED>"],
    ],
    "signature": [
        [
            "^.+$",
            "<PAINTED>"
        ]
    ],
    "video": [
        [
            "\"signature\"\\s*:\\s*\".*?\"",
            "\"signature\":\"<PAINTED>\""
        ],
    ],
    "whyThisAdLandingLink": [
        [
            "^.+$",
            "<PAINTED>"
        ]
    ],
    "__text__": [
        [
            "publisher_ref_id=\\d+",
            "publisher_ref_id=<PAINTED>"
        ],
        [
            "<vmap:Extension\\s+type=\"SessionID\">(\\d)+</vmap:Extension>",
            "<vmap:Extension type=\"SessionID\">PAINTED</vmap:Extension>"
        ],
        [
            "(\"seatbid\"\\s*:\\s*\\[\\s*\\{.*?\"bid\"\\s*:\\s*\\[\\s*\\{.*?\\s*\"id\"\\s*:\\s*)\"[0-9]+\"",
            "\\1\"<PAINTED>\""
        ],
        [
            "Last-Modified: ?\\w+, ?\\d{1,2}-\\w+-\\d{4} ?\\d{2}:\\d{2}:\\d{2} GMT",
            "Last-Modified: <PAINTED>"
        ],
        [
            "'rtb.async\\d+'",
            "'rtb.async<PAINTED>'"
        ],
        [
            "(aff_sub\\d?)=\\d+",
            "\\1=<PAINTED>"
        ],
        [
            "_1lpb_clickId=\\d*",
            "_1lpb_clickId=<PAINTED>"
        ],
        [
            "Expires: ?\\w+, ?\\d{1,2}-\\w+-\\d{4} ?\\d{2}:\\d{2}:\\d{2} GMT",
            "Expires: <PAINTED>"
        ],
        [
            "expires=\\w+, ?\\d{1,2}-\\w+-\\d{4} ?\\d{2}:\\d{2}:\\d{2} GMT",
            "expires=<PAINTED>"
        ],
        [
            "\"bid\":(\\s*)\\[\\{\n(\\s*)\"id\"(\\s*):(\\s*)\"[0-9]+\"",
            "\"bid\":\\1\\[\\{\n\\2\"id\"\\3:\\4\"<PAINTED>\""
        ],
        [
            "yandexuid=[0-9]*",
            "yandexuid=<PAINTED>"
        ],
        [
            "\"bannerid\" ?:(?: ?)\"([0-9]*):[0-9]*",
            "\"bannerid\": \"\\1:<PAINTED>"
        ],
        [
            "<SessionID>[0-9]+</SessionID>",
            "<SessionID><PAINTED></SessionID>"
        ],
        [
            "\"cid\"\\s*:\\s*\"\\d+\"",
            "\"cid\":\"<PAINTED>\""
        ],
        [
            "set-yp-user-bans=\\d*",
            "set-yp-user-bans=<PAINTED>"
        ],
        [
            "&dp=\\d*",
            "&dp=<PAINTED>",
        ],
        # https://st.yandex-team.ru/SHMDUTY-63
        [
            "\"signature\"\\s*:\\s*\".*?\"",
            "\"signature\":\"<PAINTED>\""
        ],
        [
            "\"whyThisAdLandingLink\"\\s*:\\s*\".*?\"",
            "\"whyThisAdLandingLink\":\"<PAINTED>\""
        ],
    ],
}
# additional transformations for YabsServerABExperimentTest tasks
AB_RESPONSE_TRANSFORMATION = deepcopy(RESPONSE_TRANSFORMATION)
AB_RESPONSE_TRANSFORMATION["__text__"] += [
    ["&?yabs-expflags=[a-zA-Z0-9+=]+", ""],
    ["&?yabs-expboxes=[a-zA-Z0-9+=]+", ""],
]

EXT_TRANSFORMATION = {
    "__text__": [
        [
            "&click_?(i|I)d(=|%3D)\\d+",
            "&clickid=<PAINTED>"
        ],
        [
            "\"signature\"\\s*:\\s*\".*?\"",
            "\"signature\":\"<PAINTED>\""
        ],
        [
            "&bids(=|%3D)[a-zA-Z0-9%=]+",
            "&bids=<PAINTED>",
            "ads_adfox"
        ],
        [
            "reqid(=|%3D)\\d*",
            "reqid=<PAINTED>"
        ],
        [
            "regid(=|%3D)\\d*",
            "regid=<PAINTED>"
        ],
        [
            "logid=\\d*",
            "logid=<PAINTED>"
        ],
        [
            "LOGID=\\d*",
            "LOGID=<PAINTED>"
        ],
    ],
    "X-Adfox-Request-ID": [
        ["\\d+", "<PAINTED>"],
    ],
    "Ab-Experiment-Settings": [
        [".*", "<PAINTED>"],
    ],
    "Content-Length": [
        [
            "\\d+",
            "<PAINTED>",
        ],
    ],
    "x-yabs-multipart-boundary": [
        [
            "\\d+",
            "<PAINTED>",
        ],
    ],
    "x-yabs-multipart-boundary-wordnet": [
        [
            "\\d+",
            "<PAINTED>",
        ],
    ],
    "*": [
        [
            "click_?(i|I)d(=|%3D)\\d+",
            "clickid=<PAINTED>"
        ],
        [
            "&dp=\\d*",
            "&dp=<PAINTED>",
        ],
        [
            "reqid(=|%3D)\\d*",
            "reqid=<PAINTED>"
        ],
        [
            "regid(=|%3D)\\d*",
            "regid=<PAINTED>"
        ],
        [
            "logid=\\d*",
            "logid=<PAINTED>"
        ],
        [
            "LOGID=\\d*",
            "LOGID=<PAINTED>"
        ],
    ],
    "cookie": [
        [
            "yabs-frequency=/[a-zA-Z,=,0-9]+//",
            "yabs-frequency=/<PAINTED>/"
        ],
    ],
}
# additional transformations for YabsServerABExperimentTest tasks
AB_EXT_TRANSFORMATION = deepcopy(EXT_TRANSFORMATION)
AB_EXT_TRANSFORMATION["yandex_expboxes"] = [[".*", "<PAINTED>"]]
AB_EXT_TRANSFORMATION["yandex_expflags"] = [[".*", "<PAINTED>"]]

EXT_IGNORES = {
    "exts_request_data": [
        "bigb_user_storage",
        "pcode_renderer",
        "linear_models_service",
        "linear_models_service_wide",
    ],
}
# additional transformations for YabsServerABExperimentTest tasks
AB_EXT_IGNORES = deepcopy(EXT_IGNORES)
exts_headers_data = AB_EXT_IGNORES.setdefault("exts_headers_data", [])
exts_headers_data.extend([
    "pcode_renderer",
    "yabs",
    "an_to_yabs_redirect_bad",
    "yabs_to_an_redirect_bad",
    "ads_adfox",
    "meta",
    "count",
])
