import urllib

from sandbox.projects.yabs.qa.template_utils import get_template
from sandbox.projects.yabs.qa.tasks.YabsServerB2BFuncShootCmp.report import templates_dir


def get_query(template_name, query_params):
    template_yt = get_template(template_name, templates_dir=templates_dir)
    query = template_yt.render(query_params)

    return urllib.quote_plus(query)


def get_query_yt(query_params):
    from yql.config import YqlConfig

    query = get_query('query_yt.txt', query_params)
    return '<a href="{url}/?type=SQLv1&query={query}" target="_blank">YT query example</a>'.format(
        url=YqlConfig.web_url,
        query=query
    )


def get_query_chyt(query_params):
    from yql.config import YqlConfig

    query = get_query('query_chyt.txt', query_params)
    return '<a href="{url}/?type=CLICKHOUSE&query={query}" target="_blank">CHYT query example (for first shoot only)</a>'.format(
        url=YqlConfig.web_url,
        query=query
    )
