import json

from sandbox.projects.yabs.qa.response_tools.preparse import JSON_RESPONSE_SPLITTER

from sandbox.projects.yabs.qa.tasks.YabsServerB2BFuncShootCmp.utils.compare_dict import compare_dicts
from sandbox.projects.yabs.qa.tasks.YabsServerB2BFuncShootCmp.utils.compare_response_trees import build_diff_tree


def parse_json_block(raw_str, ignore_blocks_order=False):
    if JSON_RESPONSE_SPLITTER in raw_str:
        parsed = map(json.loads, raw_str.split(JSON_RESPONSE_SPLITTER))
        if ignore_blocks_order:
            parsed.sort()
    else:
        parsed = json.loads(raw_str)
    return parsed


def compare_json_strings(a_decoded_text, b_decoded_text, ignore_blocks_order=False, diff_context=3):
    a_block = parse_json_block(a_decoded_text, ignore_blocks_order=ignore_blocks_order)
    b_block = parse_json_block(b_decoded_text, ignore_blocks_order=ignore_blocks_order)

    return compare_dicts(a_block, b_block, diff_context=diff_context)


def compare_responses(pre_decoded_text, test_decoded_text):
    pre_list = parse_json_block(pre_decoded_text)
    test_list = parse_json_block(test_decoded_text)

    return build_diff_tree(pre_list, test_list, "response_data")
