import json

from sandbox.projects.yabs.qa.response_tools.preparse import split_jsonp
from sandbox.projects.yabs.qa.response_tools.parse_json import try_parse_json_with_timeout

from sandbox.projects.yabs.qa.tasks.YabsServerB2BFuncShootCmp.utils.compare_text import compare_text
from sandbox.projects.yabs.qa.tasks.YabsServerB2BFuncShootCmp.utils.compare_response_trees import build_diff_tree


def parse_jsonp_block(raw_str, jsonp_parser, jsonp_parser_options, timeout, allow_json=False):
    jsonp_parser_options = jsonp_parser_options if jsonp_parser_options else {}
    prefix, extracted_str = split_jsonp(raw_str, allow_json=allow_json)
    parsed = try_parse_json_with_timeout(
        extracted_str,
        timeout=timeout,
        jsonp_parser=jsonp_parser,
        return_errors=False,
        **jsonp_parser_options)
    return prefix, parsed


def compare_jsonp_strings(a_decoded_text, b_decoded_text,
                          jsonp_parser=json.loads, jsonp_parser_options=None,
                          timeout=4, allow_json=False, diff_context=3):
    a_callback_name, a_block = parse_jsonp_block(a_decoded_text, jsonp_parser, jsonp_parser_options, timeout, allow_json=allow_json)
    b_callback_name, b_block = parse_jsonp_block(b_decoded_text, jsonp_parser, jsonp_parser_options, timeout, allow_json=allow_json)

    a_prettified = json.dumps(a_block, indent=2, separators=(",", ": "), sort_keys=True)
    b_prettified = json.dumps(b_block, indent=2, separators=(",", ": "), sort_keys=True)

    a = a_callback_name + ("(" if a_callback_name else "") + a_prettified + (")" if a_callback_name else "")
    b = b_callback_name + ("(" if b_callback_name else "") + b_prettified + (")" if b_callback_name else "")

    return compare_text(a, b, diff_context=diff_context)


def compare_jsonp_responses(a_decoded_text, b_decoded_text,
                            jsonp_parser=json.loads, jsonp_parser_options=None,
                            timeout=4, allow_json=False):
    _, a_block = parse_jsonp_block(a_decoded_text, jsonp_parser, jsonp_parser_options, timeout, allow_json=allow_json)
    _, b_block = parse_jsonp_block(b_decoded_text, jsonp_parser, jsonp_parser_options, timeout, allow_json=allow_json)

    return build_diff_tree(a_block, b_block, "response_data")
