from collections import defaultdict
from copy import deepcopy
import re


class DiffSymbol(object):
    def __init__(self, label):
        self.label = label

    def __str__(self):
        return "$" + self.label

    def __hash__(self):
        return hash(self.label)

    def __eq__(self, other):
        return type(other) == DiffSymbol and self.label == other.label


delete_symbol = DiffSymbol('delete')
add_symbol = DiffSymbol('add')
insert_symbol = DiffSymbol('insert')
missing_symbol = DiffSymbol('missing')


# Converted
def add_tree_patch(tree, patch):
    if tree is None:
        return deepcopy(patch)
    if patch is None:
        return deepcopy(tree)
    ans = dict()
    keys = set([key for key in tree]) | set([key for key in patch])
    for key in keys:
        if (key in tree) and (key not in patch):
            ans[key] = deepcopy(tree[key])
        elif (key not in tree) and (key in patch):
            ans[key] = deepcopy(patch[key])
        else:
            if key in [insert_symbol, missing_symbol]:
                ans[key] = max(tree[key], patch[key])
            elif key in [add_symbol, delete_symbol]:
                ans[key] = tree[key] | patch[key]
            else:
                ans[key] = add_tree_patch(tree[key], patch[key])
    return ans


# Unconverted
def preProcessDiffItems(pre_test, added_dict, diff, delete_symbol, insert_symbol):
    import jsondiff
    for key, value in pre_test.items():
        if type(key) == jsondiff.symbols.Symbol:
            if str(key) == str(jsondiff.symbols.delete):
                diff[delete_symbol] = diff.get(delete_symbol, set()) | set(key for key in value)
            if str(key) == str(jsondiff.symbols.insert):
                diff[insert_symbol] = len(value)
            if str(key) == str(jsondiff.symbols.replace):
                diff[delete_symbol] = diff.get(delete_symbol, set()) | set(key for key in value)
        else:
            if key not in added_dict:
                diff[delete_symbol] = diff.get(delete_symbol, set()) | set([key])


# Unconverted
def convertDiff(pre, test, pre_test, test_pre):
    import jsondiff
    diff = dict()
    # Add deleted fields and added rows
    preProcessDiffItems(pre_test, test, diff, delete_symbol, insert_symbol)
    # Add added fields and deleted rows
    preProcessDiffItems(test_pre, pre, diff, add_symbol, missing_symbol)
    for key, value in pre_test.items():
        if key in diff.get(delete_symbol, set()) or key in diff.get(add_symbol, set()):
            continue
        if type(key) == jsondiff.symbols.Symbol:
            continue
        if type(value) != dict:
            diff[key] = None
        elif type(pre) == dict and type(pre[key]) == list:
            get_ids = lambda diff: sorted([id for id in diff if type(id) == int])
            pre_test_ids = get_ids(pre_test[key])
            test_pre_ids = get_ids(test_pre[key])
            diff[key] = {}
            for pre_test_id, test_pre_id in zip(pre_test_ids, test_pre_ids):
                diff[key]["[{}]".format(test_pre_id)] = convertDiff(pre[key][test_pre_id], test[key][pre_test_id], pre_test[key][pre_test_id], test_pre[key][test_pre_id])
            for diff_symbol, diff_list in pre_test.items():
                if str(diff_symbol) == str(jsondiff.symbols.delete):
                    diff[key][missing_symbol] = len(diff_list)
            for diff_symbol, diff_list in test_pre.items():
                if str(diff_symbol) == str(jsondiff.symbols.delete):
                    diff[key][insert_symbol] = len(diff_list)
        else:
            if key not in pre:
                diff[key] = None
            else:
                diff[key] = convertDiff(pre[key], test[key], value, test_pre.get(key, {}))
    return diff


def get_diff_pre_test_and_test_pre(pre, test):
    from yabs.server.tools.jsondiff.lib import FasterJsonDiffer as Differ
    # from jsondiff import JsonDiffer as Differ
    differ = Differ(syntax='compact')
    return differ.diff(pre, test), differ.diff(test, pre)


def build_diff_tree(pre, test, block_name):
    diff = {
        block_name: defaultdict(dict)
    }
    if type(pre) == dict and type(test) == dict:
        pre_test, test_pre = get_diff_pre_test_and_test_pre(pre, test)
        diff[block_name] = convertDiff(pre, test, pre_test, test_pre)
    else:
        if type(pre) != list:
            pre = [pre]
        if type(test) != list:
            test = [test]
        for i in range(min(len(pre), len(test))):
            pre_test, test_pre = get_diff_pre_test_and_test_pre(pre[i], test[i])
            diff[block_name]["[{}]".format(i)] = add_tree_patch(diff[block_name]["[{}]".format(i)], convertDiff(pre[i], test[i], pre_test, test_pre))
        if len(pre) > len(test):
            diff[block_name] = add_tree_patch(diff[block_name], {missing_symbol: len(pre) - len(test)})
        if len(pre) < len(test):
            diff[block_name] = add_tree_patch(diff[block_name], {insert_symbol: len(test) - len(pre)})
    if diff[block_name] == {}:
        diff = {}
    return diff


def render_tree(tree, tab):
    if tree is None:
        return []
    if type(tree) == str:
        return [tree]
    def compare(item1, item2):
        item1 = item1[0]
        item2 = item2[0]
        if type(item1) != type(item2):
            if type(item2) == DiffSymbol:
                return -1
            return 1
        if type(item1) == DiffSymbol:
            symbols = [
                add_symbol,
                delete_symbol,
                missing_symbol,
                insert_symbol
            ]
            return -1 if symbols.index(item1) < symbols.index(item2) else 1
        else:
            return -1 if item1 < item2 else 1
    children = tree.items()
    children.sort(cmp=compare)

    texts = []
    append_texts = []
    by_render = defaultdict(list)
    for child, diff_tree in children:
        if type(child) == DiffSymbol:
            if child == missing_symbol:
                append_texts.append("Up to {} rows deleted".format(diff_tree))
            if child == insert_symbol:
                append_texts.append("Up to {} rows added".format(diff_tree))
            if child == add_symbol:
                append_texts.append("Added fields: {}".format(", ".join(map(str, sorted(diff_tree)))))
            if child == delete_symbol:
                append_texts.append("Deleted fields: {}".format(", ".join(map(str, sorted(diff_tree)))))
        else:
            child_texts = render_tree(diff_tree, tab)
            by_render["\n".join(child_texts)].append(child)

    render_items = by_render.items()
    render_items.sort(key=lambda item: item[1][0])
    for child_texts_joined, children_cluster in render_items:
        if all(re.match("^\\[(\\d+)\\]", child) for child in children_cluster):
            ids = sorted([int(re.match("^\\[(\\d+)\\]", child).group(1)) for child in children_cluster])
            str_ids = [str(id) for id in ids]
            children_cluster_joined = "[" + ",".join(str_ids) + "]"
        else:
            children_cluster_joined = ",".join(map(str, children_cluster))
        children_texts = [] if len(child_texts_joined) == 0 else child_texts_joined.split("\n")
        diff_tree = tree[children_cluster[0]]
        if type(diff_tree) == str or type(diff_tree) == dict and len(diff_tree) == 1 and all(type(child) != DiffSymbol for child in diff_tree):
            children_texts[0] = children_cluster_joined + "." + children_texts[0]
            texts.extend(children_texts)
        else:
            texts.append(children_cluster_joined)
            texts.extend([tab + line for line in children_texts])

    return texts + append_texts


def render_blocks(blocks):
    if blocks is None:
        return ""
    texts = []
    tab = "    "
    for block, diff_tree in blocks.items():
        texts += [block + ':']
        texts += [tab + line for line in render_tree(diff_tree, tab)]
    return '\n'.join(texts)
