from enum import Enum


class DiffMethods(Enum):
    text_diff = 0
    log_diff = 1
    no_diff = 2
    json_diff = 3
    jsonp_diff = 4  # deprecated, will be fixed in https://a.yandex-team.ru/arc/review/503161/details

    json_string_diff = 5
    jsonp_string_diff = 6


JSON_TEXT_METHODS = {
    DiffMethods.json_string_diff,
    DiffMethods.jsonp_diff,  # deprecated, will be fixed in https://a.yandex-team.ru/arc/review/503161/details
}
JSONP_TEXT_METHODS = {
    DiffMethods.jsonp_string_diff,
    DiffMethods.jsonp_diff,  # deprecated, will be fixed in https://a.yandex-team.ru/arc/review/503161/details
}


def detect_diff_method(pre_diff_method, test_diff_method):
    if pre_diff_method not in DiffMethods.__members__:
        raise ValueError("Unknown pre diff method: %s" % pre_diff_method)
    if test_diff_method not in DiffMethods.__members__:
        raise ValueError("Unknown test diff method: %s" % test_diff_method)

    if {DiffMethods[pre_diff_method], DiffMethods[test_diff_method]}.issubset(JSON_TEXT_METHODS):
        return DiffMethods.json_string_diff

    elif {DiffMethods[pre_diff_method], DiffMethods[test_diff_method]}.issubset(JSONP_TEXT_METHODS):
        return DiffMethods.jsonp_string_diff

    if DiffMethods[pre_diff_method] == DiffMethods[test_diff_method]:
        return DiffMethods[pre_diff_method]

    return DiffMethods[test_diff_method]
