from datetime import datetime, timedelta


YT_REPORT_TTL_DAYS = 7
SCHEMA = [
    {"name": "TestID", "type": "string"},
    {"name": "RequestIDBinary", "type": "string"},
]


def get_binary_request_id(request_id):
    request_id_binary = "{0:0>128b}".format(int(request_id, base=16))
    request_id_chars_binary = [request_id_binary[shift:shift + 8] for shift in range(0, 128, 8)]
    return ''.join(chr(int(c, base=2)) for c in request_id_chars_binary)


def upload_failed_test_ids_to_yt(comparison_result, yt_client, yt_report_dir, ttl=timedelta(days=YT_REPORT_TTL_DAYS)):
    failed_test_ids_table_path = yt_report_dir + '/failed_test_ids'
    yt_client.create_table(failed_test_ids_table_path, attributes={'schema': SCHEMA}, recursive=True)
    yt_client.set_attribute(yt_report_dir, 'expiration_time', (datetime.now() + ttl).isoformat())
    yt_client.write_table(
        failed_test_ids_table_path,
        [
            {"TestID": str(test_id), "RequestIDBinary": get_binary_request_id(str(test_id))}
            for test_id in comparison_result.failed_test_ids
        ],
        format='yson'
    )
    return failed_test_ids_table_path
