import json

from sandbox import sdk2
from sandbox.projects.yabs.qa.tasks.base_compare_task.task import BaseCompareTask
from sandbox.projects.yabs.qa.tasks.base_compare_task.parameters import BaseCompareTaskParameters


class YabsServerCheckProducts(BaseCompareTask):

    class Parameters(BaseCompareTaskParameters):
        with sdk2.parameters.Output:
            diff_info = sdk2.parameters.String('Diff of products')

    def on_execute(self):
        pre_task_products = json.loads(self.pre_task.Parameters.products)
        test_task_products = json.loads(self.test_task.Parameters.products)
        pre_products_names = set(pre_task_products.keys())
        test_products_names = set(test_task_products.keys())
        common_products = pre_products_names.intersection(test_products_names)

        has_diff = False
        diff_info = []
        for product in common_products:
            if pre_task_products[product] != test_task_products[product]:
                diff_info.append("Count of product {} was changed: pre {}, test {}".format(product, pre_task_products[product], test_task_products[product]))
                has_diff = True
        pre_only = pre_products_names.difference(test_products_names)
        if pre_only:
            disappeared_products = {k: v for k, v in pre_task_products.items() if k in pre_only}
            diff_info.append("The following products have disappeared from shooting results: {}".format(disappeared_products))
            has_diff = True
        test_only = test_products_names.difference(pre_products_names)
        if test_only:
            appeared_products = {k: v for k, v in test_task_products.items() if k in test_only}
            diff_info.append("The following products have appeared from shooting results: {}".format(appeared_products))
            has_diff = True
        for diff in diff_info:
            self.set_info(diff)

        self.Parameters.diff_info = '\n'.join(diff_info)
        self.Parameters.has_diff = self.Context.has_diff = has_diff
