# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.yabs.bases.keys import CHKDB_CTX_KEY, CHKDB_WITHOUT_HASH_CTX_KEY
from sandbox.projects.yabs.qa.compare import compare_chkdb
from sandbox.projects.yabs.qa.utils.resource import sync_resource
from sandbox.projects.yabs.qa.tasks.base_compare_task.task import create_input_parameters
from sandbox.projects.YabsServerDBSizeCmp import YabsServerDBSizeCmp


class YabsServerChkdbCmp(YabsServerDBSizeCmp):
    description = 'Compare yabs-server binary bases chkdb'

    class Parameters(sdk2.Parameters):
        pre_task_id = sdk2.parameters.Task('Task 1 (baseline)')
        test_task_id = sdk2.parameters.Task('Task 2 (test)')
        use_chkdb_without_hash = sdk2.parameters.Bool('Use chkdb without hash', default=False)
        cmp_input_parameters = create_input_parameters()

    class Context(sdk2.Context):
        report = ''

    def compare_contexts(self, pre_ctx, test_ctx, max_diff_percent, compare_same_bases):
        ctx_key = CHKDB_WITHOUT_HASH_CTX_KEY if self.Parameters.use_chkdb_without_hash else CHKDB_CTX_KEY
        has_chkdb_diff, report = compare_chkdb(
            getattr(pre_ctx, ctx_key), getattr(test_ctx, ctx_key), sync_resource
        )
        self.Context.report = report
        return has_chkdb_diff, report
