#!/bin/bash
# Usage: bash construct_gcov_coverage.bash arcadia-path gcdas.tar.gz server-coverage-bundle.tar.gz
set -euo pipefail  # https://pythonspeed.com/articles/shell-scripts/
log() {
    >&2 echo "`date -u`" "$@"
}

# Prepare files and dir structure
mkdir "gcov"
cd gcov
log 'Symlinking Arcadia'
ln -s "$1" sources
log "Unpacking .gcda files"
tar xzf "$2"
log "Unpacking .gcno files"
tar xz -C "yabs/server" "--strip-components=1" -f "$3"

# Prepare (environment) variables
# Extracting SOURCE_PREFIX seems flimsy but I don't see a better way
export SOURCE_PREFIX="`strings yabs/server/daemons/bs_static/main.cpp.gcno | grep -m 1 '.cpp$' | grep -Eo '^.*mount[^/]*/.*?arcadia/?'`"
log "SOURCE_PREFIX=${SOURCE_PREFIX} based on main.cpp.gcno"
export LD_PRELOAD="`readlink -f ../libpreload.so`"
log "LD_PRELOAD=${LD_PRELOAD}"
GCOV_PATH="`./sources/ya tool gcov --print-path`"
log "GCOV_PATH=${GCOV_PATH}"

# Prepare gcovr and call it
log "Building gcovr..."
./sources/ya make sources/contrib/python/gcovr
log "Copying source files..."
rsync -r "$1/yabs/server" yabs
log "Calling gcovr..."
./sources/contrib/python/gcovr/gcovr --gcov-executable "$GCOV_PATH"  -r . --html --html-details -o coverage.html yabs/server/ -f '.*cpp' \
    -e '.*serialized.*' \
    -e '.*base_ver.*' \
    -e '.*[0-9a-f]{16,}.*' \
    -e '.*__.*' \
    -e '.*/_/.*' \
    -e '.*yabs/server/cs.*' \
    -e '.*yabs/server/libs/constant/by_name.*' \
# We exclude code generation stuff because it's not in repo and cs because it's irrelevant

# Wrap up
unlink sources
#tar czf ../yabs-server-gcov-coverage.tar.gz `find . -name '*.html'`
mkdir ../yabs-server-gcov-coverage
log "Preparing html resource"
find . -print0 -name '*.html' -exec cp --parents "{}" ../yabs-server-gcov-coverage \;
