#define _FCNTL_H 1 /* hack for open() prototype */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <string.h>
#include <dlfcn.h>

#define DISTBUILD_PREFIX "/-S/"
#define REPLACEMENT_PREFIX "sources/"
static char path_buffer[4097] = REPLACEMENT_PREFIX;

static char* const _cpy_ptr = path_buffer + sizeof(REPLACEMENT_PREFIX) - 1;

int open(const char *pathname, int flags, mode_t mode){
    static int (*real_open)(const char *pathname, int flags, mode_t mode) = NULL;
    if (!real_open) {
        real_open = dlsym(RTLD_NEXT, "open");
        char *error = dlerror();
        if (error != NULL) {
            fprintf(stderr, "%s\n", error);
            exit(1);
        }
    }
    if (memcmp(pathname, DISTBUILD_PREFIX, sizeof(DISTBUILD_PREFIX) - 1) == 0) {
        if (strlen(pathname) > 4096 - sizeof(REPLACEMENT_PREFIX)) exit(2);
        memcpy(_cpy_ptr, pathname + sizeof(DISTBUILD_PREFIX) - 1, strlen(pathname) - sizeof(DISTBUILD_PREFIX) + 1);
        fprintf(stderr, "opening %s instead of %s\n", path_buffer, pathname);
        return real_open(path_buffer, flags, mode);
    }
    char* source_prefix;
    if((source_prefix = getenv("SOURCE_PREFIX")) && strlen(source_prefix) > 0 && memcmp(pathname, source_prefix, strlen(source_prefix)) == 0) {
        strcpy(_cpy_ptr, pathname + strlen(source_prefix));
        fprintf(stderr, "opening %s instead of %s\n", path_buffer, pathname);
        return real_open(path_buffer, flags, mode);
    }
//    fprintf(stderr, "no substitution: opening %s\n", pathname);
    return real_open(pathname, flags, mode);
}



int open64(const char *pathname, int flags, mode_t mode){
    static int (*real_open64)(const char *pathname, int flags, mode_t mode) = NULL;
    if (!real_open64) {
        real_open64 = dlsym(RTLD_NEXT, "open64");
        char *error = dlerror();
        if (error != NULL) {
            fprintf(stderr, "%s\n", error);
            exit(1);
        }
    }
    if (memcmp(pathname, DISTBUILD_PREFIX, sizeof(DISTBUILD_PREFIX) - 1) == 0) {
        if (strlen(pathname) > 4096 - sizeof(REPLACEMENT_PREFIX)) exit(2);
        memcpy(_cpy_ptr, pathname + sizeof(DISTBUILD_PREFIX) - 1, strlen(pathname) - sizeof(DISTBUILD_PREFIX) + 1);
        fprintf(stderr, "opening %s instead of %s\n", path_buffer, pathname);
        return real_open64(path_buffer, flags, mode);
    }
    char* source_prefix;
    if((source_prefix = getenv("SOURCE_PREFIX")) && strlen(source_prefix) > 0 && memcmp(pathname, source_prefix, strlen(source_prefix)) == 0) {
        strcpy(_cpy_ptr, pathname + strlen(source_prefix));
        fprintf(stderr, "opening %s instead of %s\n", path_buffer, pathname);
        return real_open64(path_buffer, flags, mode);
    }
//    fprintf(stderr, "no substitution: opening %s\n", pathname);
    return real_open64(pathname, flags, mode);
}



int openat(int dirfd, const char *pathname, int flags, mode_t mode) {
    fprintf(stderr, "givera1337\n");
    static int (*real_openat)(int dirfd, const char *pathname, int flags, mode_t mode) = NULL;
    if (!real_openat) {
        real_openat = dlsym(RTLD_NEXT, "openat");
        char *error = dlerror();
        if (error != NULL) {
            fprintf(stderr, "%s\n", error);
            exit(1);
        }
    }
    return real_openat(dirfd, pathname, flags, mode);
}
