from sandbox import sdk2
from sandbox.projects.yabs.qa.spec.spec import BaseSpec
from sandbox.projects.yabs.qa.resource_types import BaseBackupSdk2Resource


class YabsServerABExperimentSpec(BaseBackupSdk2Resource):
    """
    Spec for YABS_SERVER_TEST_AB_EXPERIMENT task
    """
    auto_backup = True
    ttl = 30
    releasable = True
    releasers = ['YABS_SERVER_SANDBOX_TESTS']
    released_spec = sdk2.parameters.Bool('This spec is released for public use', default=False)

    ft = sdk2.parameters.Bool('This spec contains baseline tasks for functional tests', default=False)
    stat_load = sdk2.parameters.Bool('This spec contains baseline tasks for stat load tests', default=False)
    meta_load = sdk2.parameters.Bool('This spec contains baseline tasks for meta load tests', default=False)


class ABExperimentSpec(BaseSpec):
    __slots__ = BaseSpec.__slots__ + [
        # Settings
        'drop_other_experiments',
        'validate_ab_experiment_bin_id',
    ]
