from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.projects.yabs.qa.spec.spec import BaseSpec
from sandbox.projects.yabs.qa.resource_types import BaseBackupSdk2Resource


class YABS_SERVER_HOUSE_SPEC(BaseBackupSdk2Resource):
    """
    Spec for YABS_SERVER_HOUSE task
    """
    auto_backup = True
    ttl = 30
    releasable = True
    restart_policy = ctr.RestartPolicy.IGNORE
    releasers = ['YABS_SERVER_SANDBOX_TESTS']
    released_spec = sdk2.parameters.Bool('This spec is released for public use', default=False)
    good = sdk2.parameters.Bool('This ft spec is good', default=False)
    good_with_load = sdk2.parameters.Bool('This load spec is good', default=False)


class OneShotSpec(BaseSpec):
    __slots__ = BaseSpec.__slots__ + [
        # chkdb
        'stat_chkdb_task_id',
        'meta_chkdb_task_id',

        # func
        'ft_stability_shoot_tasks',
        'ft_validation_tasks',
    ]
