import logging


logger = logging.getLogger(__name__)


DEFAULT_NAMESPACE_COUNT = {
    "banner_resources": 100,
    "banner_tier_main": 100,
    "dsp_creative": 10
}


def validate_states(states, namespace_count=None):
    """Validate states from coordinator response.
    Return missing namespace names

    :param states: list of states
    :type states: list[dict]
    :param namespace_count: number of expected streams per namespace
    :type namespace_count: dict
    :return: missing namespace names
    :rtype: set[str]
    """
    namespace_count = namespace_count or DEFAULT_NAMESPACE_COUNT

    missing_namespaces = {}
    for namespace_name, number in namespace_count.items():
        missing_namespaces[namespace_name] = set(range(number))

    for state in states:
        namespace_name, namespace_index = state["Namespace"].split('-')
        namespace_index = int(namespace_index)
        try:
            missing_namespaces[namespace_name].discard(namespace_index)
        except KeyError:
            logger.warning("Unexpected namespace: %s", namespace_name)

    result = []
    for namespace_name, missing_indexes in missing_namespaces.items():
        for index in missing_indexes:
            result.append("{}-{}".format(namespace_name, index))

    return result
