import json

from sandbox import sdk2
from sandbox.projects.yabs.qa.resource_types import YABS_SERVER_STAT_SPEC, BS_RELEASE_YT, BS_RELEASE_TAR

from sandbox.projects.common.yabs.server.tracing import TRACE_WRITER_FACTORY
from sandbox.projects.yabs.sandbox_task_tracing import trace_entry_point
from sandbox.projects.yabs.sandbox_task_tracing.wrappers.sandbox.sdk2 import new_resource_data


class YabsServerGenerateBaseGenParameters(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        stat_spec_resource = sdk2.parameters.Resource(
            "Stat spec resource",
            resource_type=YABS_SERVER_STAT_SPEC,
            required=True
        )

        with sdk2.parameters.Output:
            bs_release_yt_resource = sdk2.parameters.Resource('Stable Yabs CS package', resource_type=BS_RELEASE_YT)
            bs_release_tar_resource = sdk2.parameters.Resource('Stable Yabs server package', resource_type=BS_RELEASE_TAR)

    @trace_entry_point(writer_factory=TRACE_WRITER_FACTORY)
    def on_execute(self):
        stat_spec_resource = sdk2.Resource[self.Parameters.stat_spec_resource]
        stat_spec_resource_path = str(new_resource_data(stat_spec_resource).path)
        with open(stat_spec_resource_path) as f:
            stat_spec = json.load(f)

        self.Parameters.bs_release_yt_resource = stat_spec["bs_release_yt_resource_id"]
        self.Parameters.bs_release_tar_resource = stat_spec["bs_release_tar_resource_id"]
