DEFAULT_SPEC = {
    "bs_func": {
        "mode": "metapartner",
        "make_load": False,
        "limits": [
            {
                "lower": {"meta": 20000, "metadsp": 1000, "page": 18000, "count": 18500, "code": 2000, "OTHER": 1},
                "upper": {"audit": 2, "OTHER": 100},
            },
            {
                "lower": {"RANDOM": 500},
                "upper": {"RANDOM": 200000}
            },
        ],
    },
    "bs_load": {
        "mode": "metapartner",
        "make_load": True,
        "limits": [
            {
                "lower": {"RANDOM": 50000},
                "upper": {"RANDOM": 5000000},
            }
        ],
    },
    "yabs_func": {
        "mode": "metasearch",
        "make_load": False,
        "limits": [
            {
                "lower": {"code": 20000, "page": 20000, "count": 19500, "OTHER": 1},
                "upper": {"audit": 2, "OTHER": 100},
            },
            {
                "lower": {"RANDOM": 500},
                "upper": {"RANDOM": 200000}
            },
        ],
    },
    "yabs_load": {
        "mode": "metasearch",
        "make_load": True,
        "limits": [
            {
                "lower": {"RANDOM": 5000},
                "upper": {"RANDOM": 1000000},
            }
        ],
    },
    "bsrank_func": {
        "mode": "metarank",
        "make_load": False,
        "limits": [
            {
                "lower": {"rank": 59500, "OTHER": 1},
                "upper": {"audit": 2, "OTHER": 100},
            },
            {
                "lower": {"RANDOM": 500},
                "upper": {"RANDOM": 200000},
            },
        ],
    },
    "bsrank_load": {
        "mode": "metarank",
        "make_load": True,
        "limits": [{
            "lower": {"RANDOM": 5000},
            "upper": {"RANDOM": 1000000},
        }],
    },
}

_NEEDED_SPEC_KEYS = {"mode", "limits"}
_ALLOWED_SPEC_KEYS = _NEEDED_SPEC_KEYS | {"make_load", "limiting_mode", "create_requestlog", "create_dplan"}
_LIMITS_SUBKEYS = {"upper", "lower"}


class BadSpec(ValueError):
    pass


def validate_spec(spec):
    # TODO as for now, we cannot  use jsonschema because we need this in on_enqueue
    for name, section in spec.iteritems():
        _ensure_empty(section.viewkeys() - _ALLOWED_SPEC_KEYS, "Bad keys in section {}".format(name))
        _ensure_empty(_NEEDED_SPEC_KEYS - section.viewkeys(), "Keys missing from section {}".format(name))

        if not isinstance(section.get("make_load", False), bool):
            raise BadSpec("Section %s: make_load should be bool" % name)

        for limits_subsection in section['limits']:
            _ensure_empty(limits_subsection.viewkeys() - _LIMITS_SUBKEYS, "Bad keys in limits in section {}".format(name))
            for kind, limits in limits_subsection.iteritems():
                if any(not isinstance(v, int) for v in limits.itervalues()):
                    raise BadSpec("Section %s: invalid value in %s limits" % (name, kind))


def _ensure_empty(s, error_prefix):
    if s:
        raise BadSpec('{}: {}'.format(error_prefix, ', '.join(s)))


validate_spec(DEFAULT_SPEC)  # Fail module import if default spec is not valid
