from sandbox import sdk2

from sandbox.sandboxsdk.environments import PipEnvironment

from sandbox.projects.yabs.qa.tasks.cs_helpers import CSHelper
from sandbox.projects.yabs.qa.resource_types import (
    BaseBackupSdk2Resource,
    BS_RELEASE_YT,
    YABS_CS_SETTINGS_ARCHIVE,
    YABS_CS_SETTINGS_PATCH
)
from sandbox.projects.common.yabs.server.db.utils import get_yabscs
from sandbox.projects.common.yabs.server.db import yt_bases


SUPPORTED_CS_TOOLS = [
    'cs'
]


class YabsServerRunCSStdOut(BaseBackupSdk2Resource):
    pass


class YabsServerRunCS(sdk2.Task, CSHelper):
    name = 'YABS_SERVER_RUN_CS'
    description = 'Run CS tool'

    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024
        environments = (
            PipEnvironment('jsondiff', version='1.2.0'),
        )

    class Parameters(sdk2.Parameters):
        tool = sdk2.parameters.String('Tool to run', choices=[(tool, tool) for tool in SUPPORTED_CS_TOOLS], default=SUPPORTED_CS_TOOLS[0])
        args = sdk2.parameters.String('Mandatory positional arguments of tool, like "advmachine_export banners"', required=True)
        bs_release_yt_resource = sdk2.parameters.Resource('BS release yt resource', resource_type=BS_RELEASE_YT)
        yt_token_vault_name = sdk2.parameters.String('Vault name for YT token', required=True, default='yabs-cs-sb-yt-token')
        yt_proxy = sdk2.parameters.String('YT cluster', required=True, default='hahn')
        settings_spec = sdk2.parameters.JSON("cs settings spec", required=False)
        settings_archive = sdk2.parameters.Resource("cs settings", resource_type=YABS_CS_SETTINGS_ARCHIVE)
        cs_settings_patch = sdk2.parameters.Resource("Updates CS settings using jsondiff", resource_type=YABS_CS_SETTINGS_PATCH, required=False)
        save_stdout = sdk2.parameters.Bool('Enable saving cs stdout to resource', default=False)

    class Context(sdk2.Task.Context):
        yabs_cs_path = None

    def get_yabscs(self):
        """Sync and unpack BS_RELEASE_YT"""
        if not self.Context.yabs_cs_path:
            self.Context.yabs_cs_path = get_yabscs(self, self.Parameters.bs_release_yt_resource.id)
        return self.Context.yabs_cs_path

    @property
    def yt_token(self):
        return sdk2.Vault.data(
            self.owner,
            self.Parameters.yt_token_vault_name,
        )

    def on_execute(self):
        stdout_path = yt_bases.run_cs_tool(
            yt_token=self.yt_token,
            proxy=self.Parameters.yt_proxy,
            cs_cycle_dir=self.get_yabscs(),
            tool=self.Parameters.tool,
            args=self.Parameters.args.split(),
            settings_spec=self.cs_settings,
            task_id=self.id,
        )

        if self.Parameters.save_stdout:
            resource = YabsServerRunCSStdOut(self, 'CS stdout', 'cs_stdout.log')
            resource_data = sdk2.ResourceData(resource)
            with open(stdout_path) as out:
                resource_data.path.write_bytes(out.read())
            resource_data.ready()
