import itertools
import logging

from sandbox.projects.yabs.qa.tasks.YabsServerShmResourceGC.spec import get_last_released_spec_data


logger = logging.getLogger(__name__)


def _get_active_ab_experiment_spec_binary_base_resources(sandbox_client):
    spec_data = get_last_released_spec_data(
        resource_type="YABS_SERVER_ABEXPERIMENT_SPEC",
        sandbox_client=sandbox_client,
    )
    return list(set(spec_data["stat_binary_base_resource_id_by_tag"].values() + spec_data["meta_binary_base_resource_id_by_tag"].values()))


def _get_active_one_shot_spec_binary_base_resources(sandbox_client):
    spec_data = get_last_released_spec_data(
        resource_type="YABS_SERVER_HOUSE_SPEC",
        sandbox_client=sandbox_client,
    )
    return list(set(spec_data["stat_binary_base_resource_id_by_tag"].values() + spec_data["meta_binary_base_resource_id_by_tag"].values()))


def get_active_binary_base_resources(sandbox_client):
    ab_experiment_binary_base_resources = _get_active_ab_experiment_spec_binary_base_resources(sandbox_client)
    logger.debug("AB-experiment binary base resources: %s", ab_experiment_binary_base_resources)

    one_shot_binary_base_resources = _get_active_one_shot_spec_binary_base_resources(sandbox_client)
    logger.debug("Oneshot binary base resources: %s", one_shot_binary_base_resources)

    return list(set(itertools.chain(ab_experiment_binary_base_resources, one_shot_binary_base_resources)))


def ping_active_binary_base_resources(sandbox_client, active_binary_base_resources):
    for binary_base_resource_id in active_binary_base_resources:
        sandbox_client.resource[binary_base_resource_id].touch()
