import itertools
import logging
import requests

from sandbox.projects.common.yabs.server.db.yt_bases import renew_input_spec_expiration_time
from sandbox.projects.yabs.qa.tasks.YabsServerShmResourceGC.spec import get_last_released_spec_data


logger = logging.getLogger(__name__)


def _get_active_testenv_cs_input_spec_resources(testenv_resources, ignore_statuses=('BAD', 'OK_OLD', )):
    active_cs_input_spec_resources = []
    for testenv_resource in testenv_resources:
        resource_status = testenv_resource['status']
        if testenv_resource['name'] == 'YABS_CS_INPUT_SPEC' and resource_status not in ignore_statuses:
            active_cs_input_spec_resources.append(testenv_resource['resource_id'])
            logger.debug('Found active %s %s, resource_id=%s', resource_status, testenv_resource['name'], testenv_resource['resource_id'])
    return active_cs_input_spec_resources


def _get_active_one_shot_spec_cs_input_spec_resources(sandbox_client):
    spec_data = get_last_released_spec_data(
        resource_type="YABS_SERVER_HOUSE_SPEC",
        sandbox_client=sandbox_client,
    )
    return [spec_data["cs_input_spec_resource_id"]]


def get_active_cs_input_spec_resources(testenv_resources, sandbox_client):
    testenv_cs_input_spec_resources = _get_active_testenv_cs_input_spec_resources(testenv_resources)
    logger.debug("Testenv CS input spec resources: %s", testenv_cs_input_spec_resources)

    oneshot_cs_input_spec_resources = _get_active_one_shot_spec_cs_input_spec_resources(sandbox_client)
    logger.debug("Oneshot spec CS input spec resources: %s", oneshot_cs_input_spec_resources)

    return list(set(itertools.chain(testenv_cs_input_spec_resources, oneshot_cs_input_spec_resources)))


def ping_active_cs_input_spec_resources(yt_client, sandbox_client, active_cs_input_spec_resources, ttl):
    for resource_id in active_cs_input_spec_resources:
        cs_input_spec_resource = sandbox_client.resource.read(id=resource_id, limit=1)['items'][0]
        r = requests.get(cs_input_spec_resource["http"]["proxy"])
        r.raise_for_status()
        cs_input_spec_data = r.json()
        renew_input_spec_expiration_time(yt_client, cs_input_spec_data, ttl=ttl)
