import logging
import requests


logger = logging.getLogger(__name__)


def get_last_released_spec_data(resource_type, sandbox_client):
    request = {
        "limit": 1,
        "offset": 0,
        "order": "-id",
        "type": resource_type,
        "attrs": {"released_spec": True},
    }
    spec_resource = sandbox_client.resource.read(request)['items'][0]
    logger.debug("Found spec resource %s for resource type %s", spec_resource["id"], resource_type)

    r = requests.get(spec_resource["http"]["proxy"])
    r.raise_for_status()
    return r.json()
