import logging

import sandbox.common.types.client as ctc
import sandbox.common.types.misc as ctm

from sandbox.projects.yabs.qa.sut.metastat.adapters.sandbox import YabsMetaSandboxAdapter, YabsStatSandboxAdapter
from sandbox.projects.yabs.qa.ammo_module.dplan.adapters.sandbox import AmmoDplanModuleSandboxAdapter
from sandbox.projects.yabs.qa.ammo_module.requestlog.adapters.yabs_specific.sandbox import AmmoRequestlogModuleYabsStatPerformanceSandboxAdapter
from sandbox.projects.yabs.qa.dolbilo_module.simple.adapters.sandbox import DolbiloModuleSandboxAdapter
from sandbox.projects.yabs.qa.tasks.YabsServerStatPerformance2 import YabsServerStatPerformance2, MB_IN_GB
from sandbox.projects.yabs.qa.utils.base import get_bin_bases_unpacked_size, get_max_unpacking_workers

logger = logging.getLogger(__name__)


class YabsServerStatPerformanceSanitize(YabsServerStatPerformance2):
    """
    YabsServerStatPerformance2 task without INTEL_E5_2650 & LINUX_PRECISE requirements
    Task for sanitize b2b tests of yabs-server service.
    """
    class Parameters(YabsServerStatPerformance2.Parameters):
        meta_module_parameters = YabsMetaSandboxAdapter.get_init_parameters_class()()

    class Requirements(YabsServerStatPerformance2.Requirements):
        client_tags = ctc.Tag.LXC

    def on_save(self):
        super(YabsServerStatPerformanceSanitize, self).on_save()
        self.Requirements.ram = self.Parameters.ram_space * MB_IN_GB
        shard_count = len(self.Parameters.stat_shards)
        bin_bases_unpacked_size = []
        if self.Parameters.use_tmpfs:
            bin_bases_unpacked_size = get_bin_bases_unpacked_size(self.Parameters.meta_binary_base_resources + self.Parameters.stat_binary_base_resources)
            self.Context.ramdrive_size = min((self.Parameters.shard_space * shard_count) * MB_IN_GB, sum(bin_bases_unpacked_size) + 10 * MB_IN_GB)
            self.Requirements.ramdrive = ctm.RamDrive(
                ctm.RamDriveType.TMPFS,
                self.Context.ramdrive_size,
                None
            )
            self.Requirements.disk_space = self.Parameters.generic_disk_space * MB_IN_GB
        else:
            self.Requirements.ramdrive = None
            self.Requirements.disk_space = (self.Parameters.generic_disk_space + (self.Parameters.shard_space * shard_count)) * MB_IN_GB
        self.Context.unpacking_workers = get_max_unpacking_workers(bin_bases_unpacked_size, self.Requirements.ram, self.Context.ramdrive_size)

    def shoot(self):
        self.validate_parameters(self.Parameters)
        with self.stage_duration("create_modules"):
            stat_adapter = YabsStatSandboxAdapter(
                self.Parameters,
                task_instance=self,
                work_dir="stat_adapter",
            )
            cachedaemon = stat_adapter.create_cachedaemon()
            stat_module = stat_adapter.create_module(
                cachedaemon=cachedaemon,
                maximum_keys_per_tag=1,
                use_sandbox_config=False,
                max_unpacking_workers=self.Context.unpacking_workers
            )

            meta_adapter = YabsMetaSandboxAdapter(
                self.Parameters,
                task_instance=self,
                work_dir="meta_adapter",
            )
            meta_module = meta_adapter.create_module(
                cachedaemon=cachedaemon,
                stat_instances=stat_module.get_instances(),
                shared_base_state=stat_module.shared_base_state,
                maximum_keys_per_tag=1,
                use_sandbox_config=False,
                max_unpacking_workers=self.Context.unpacking_workers
            )
        shoot_module = DolbiloModuleSandboxAdapter(self.Parameters, self).create_module()

        if self.Parameters.use_requestlog:
            ammo_module = AmmoRequestlogModuleYabsStatPerformanceSandboxAdapter(self.Parameters, self).create_module()
        else:
            ammo_module = AmmoDplanModuleSandboxAdapter(self.Parameters, self).create_module()

        dplan_path = ammo_module.get_dplan_path()
        with cachedaemon, stat_module, meta_module:
            shoot_module.shoot_and_watch(meta_module, dplan_path)

    def on_execute(self):
        self.shoot()
