SB_STYLE = '''
.table {
    white-space: normal;
}
.table table {
    border-collapse: collapse;
}
.table th {
    padding: 2px 8px;
    text-align: left;
    vertical-align: top;
    background-color: #f2f2f2;
    border: 1px solid #ddd;
}
.table tr {
    padding: 2px 8px;
    text-align: left;
    vertical-align: top;
}
.table td {
    padding: 2px 8px;
    border: 1px solid #ddd;
}
.table pre {
    white-space: pre-wrap;
}
'''


class Status(object):
    OK = "OK"
    FAIL = "FAIL"


COLORS_BY_STATUS = {
    Status.FAIL: "red",
    Status.OK: "green",
}
STARTREK_REPORT_TEMPLATE = '''
{% if report_data.versions -%}
===Stat server version
%%{{ report_data.versions.stat_server }}%%
===Meta server version
%%{{ report_data.versions.meta_server }}%%
{% endif -%}
{% if report_data.data_resources -%}
===Data resources
#|
|| **Resource** | **Creation time** ||
|| MySQL archive | {{ report_data.data_resources.mysql_archive }} ||
|| CS input spec | {{ report_data.data_resources.cs_input_spec }} ||
|#
{% endif -%}
{% if report_data.func -%}
===Functional tests
#|
|| **Role/Shard** | **Functional test results** | **Validation status** | **Ammo creation time** ||
{% for row in report_data.func -%}
||
{{ row.role }}/{{ row.shard }} |
(({{ row.cmp_task_link }} {{ row.cmp_task_id }})) !!({{ color_map.get(row.cmp_status) }}){{ row.cmp_status }}!! (({{ row.cmp_report_link }} {{ row.cmp_report_text }})) |
(({{ row.validation_task_link }} {{ row.validation_task_id }})) !!({{ color_map.get(row.validation_status) }}){{ row.validation_status }}!! |
{{ row.ammo_created }}
||
{% endfor -%}
|#
{% endif -%}
{% if report_data.stability -%}
===Stability tests
#|
|| **Role/Shard** | **Result** ||
{% for row in report_data.stability -%}
|| {{ row.role }}/{{ row.shard }} | (({{ row.task_link }} Stability)): !!({{ color_map.get(row.status) }}){{ row.status }}!! ||
{% endfor -%}
|#
{% endif -%}
{% if report_data.load -%}
===Load tests
#|
|| **Role/shard** | **RPS change** | **Ammo creation time** ||
{% for row in report_data.load %}
|| {{ row.role }}/{{ row.shard }} | {{ row.short_report_text }} | {{ row.ammo_created }} ||
{% endfor %}
|#
{% endif %}
{% if report_data.perf_meta -%}
===Perf meta tests
#|
|| **Role** | **RPS change** | **Ammo creation time** ||
{% for row in report_data.perf_meta %}
|| {{ row.role }} | {{ row.st_report }} | {{ row.ammo_created }} ||
{% endfor %}
|#
{% endif %}
{% if report_data.chkdb %}
===Chkdb tests
<{Chkdb report
%%
{{ report_data.chkdb.report }}
%%
}>
{% if report_data.chkdb.report_is_too_long -%}
Chkdb report is too long, for full report please visit (({{ report_data.chkdb.task_link }} chkdb task))
{%- else -%}
Generated by (({{ report_data.chkdb.task_link }} chkdb task))
{% endif %}
{% endif %}
{% if report_data.stat_chkdb %}
===Chkdb tests
<{Chkdb report
%%
{{ report_data.stat_chkdb.report }}
%%
}>
{% if report_data.stat_chkdb.report_is_too_long -%}
Stat chkdb report is too long, for full report please visit (({{ report_data.stat_chkdb.task_link }} chkdb task))
{%- else -%}
Generated by (({{ report_data.stat_chkdb.task_link }} stat chkdb task))
{% endif %}
{% endif %}
{% if report_data.meta_chkdb %}
===Chkdb tests
<{Chkdb report
%%
{{ report_data.meta_chkdb.report }}
%%
}>
{% if report_data.meta_chkdb.report_is_too_long -%}
Meta chkdb report is too long, for full report please visit (({{ report_data.meta_chkdb.task_link }} chkdb task))
{%- else -%}
Generated by (({{ report_data.meta_chkdb.task_link }} meta chkdb task))
{% endif %}
{% endif %}
{% if report_data.stat_import_stability %}
===Stat import stability tests
%%
{{ report_data.stat_import_stability.report }}
%%
Generated by (({{ report_data.stat_import_stability.task_link }} import_test_stability task))
{% endif %}
{% if report_data.meta_import_stability %}
===Meta import stability tests
%%
{{ report_data.meta_import_stability.report }}
%%
Generated by (({{ report_data.meta_import_stability.task_link }} import_test_stability task))
{% endif %}
'''

HTML_REPORT_TEMPLATE = '''
<style>
{{ style }}
</style>
<div class="table">
{% if report_data.versions -%}
<h2>Stat server version</h2>
<pre>{{ report_data.versions.stat_server }}</pre>
<h2>Meta server version</h2>
<pre>{{ report_data.versions.meta_server }}</pre>
{% endif -%}
{% if report_data.data_resources -%}
<h2>Data resources</h2>
<table>
    <thead>
        <th>Resource</th>
        <th>Creation time</th>
    </thead>
    <tbody>
        <tr>
            <td>MySQL archive</td><td>{{ report_data.data_resources.mysql_archive }}</td>
        </tr>
        <tr>
            <td>CS input spec</td><td>{{ report_data.data_resources.cs_input_spec }}</td>
        </tr>
    </tbody>
</table>
{% endif -%}
{% if report_data.func -%}
<h2>Functional tests</h2>
<table>
    <thead>
        <tr>
            <th>Role/Shard</th>
            <th colspan=2>Functional test status</th>
            <th>Validation status</th>
            <th>Ammo creation time</th>
        </tr>
    </thead>
    <tbody>
    {% for row in report_data.func -%}
        <tr>
            <td>{{ row.role }}/{{ row.shard }}</td>
            <td><a href="{{ row.cmp_task_link }}" target="_blank">{{ row.cmp_task_id }}</a>&nbsp;<span style="color: {{ color_map.get(row.cmp_status) }}">{{ row.cmp_status }}</span></td>
            <td><a href="{{ row.cmp_report_link }}" target="_blank">{{ row.cmp_report_text }}</a></td>
            <td><a href="{{ row.validation_task_link }}" target="_blank">{{ row.validation_task_id }}</a>&nbsp;
<span style="color: {{ color_map.get(row.validation_status) }}">{{ row.validation_status }}</span></td>
            <td>{{ row.ammo_created }}</td>
        </tr>
    {% endfor -%}
    </tbody>
</table>
{% endif -%}
{% if report_data.stability -%}
<h2>Stability tests</h2>
<table>
    <thead>
        <tr>
            <th>Role/Shard</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
    {% for row in report_data.stability -%}
        <tr>
            <td>{{ row.role }}/{{ row.shard }}</td>
            <td>
                <a href="{{ row.task_link }}" target="_blank">{{ row.task_id }}</a>&nbsp;<span style="color: {{ color_map.get(row.status) }}">{{ row.status }}</span>
            </td>
        </tr>
    {% endfor -%}
    </tbody>
</table>
{% endif -%}
{% if report_data.load -%}
<h2>Load tests</h2>
<table>
    <thead>
        <tr>
            <th>Role/Shard</th>
            <th>Status</th>
            <th>Result</th>
            <th>Ammo created</th>
        </tr>
    </thead>
    <tbody>
    {% for row in report_data.load -%}
        <tr>
            <td>{{ row.role }}/{{ row.shard }}</td>
            <td><a href="{{ row.cmp_task_link }}" target="_blank">{{ row.cmp_task_id }}</a>&nbsp;<span style="color: {{ color_map.get(row.cmp_status) }}">{{ row.cmp_status }}</span></td>
            <td>{{ row.cmp_report_text }}</td>
            <td>{{ row.ammo_created }}</a></td>
        </tr>
    {% endfor -%}
    </tbody>
</table>
{% endif -%}
{% if report_data.perf_meta -%}
<h2>Perf meta tests</h2>
<table>
    <thead>
        <tr>
            <th>Role</th>
            <th>RPS change</th>
            <th>Ammo creation time</th>
        </tr>
    </thead>
    <tbody>
    {% for row in report_data.perf_meta -%}
        <tr>
            <td>{{ row.role }}</td>
            <td>{{ row.html_report }}</td>
            <td>{{ row.ammo_created }}</td>
        </tr>
    {% endfor -%}
    </tbody>
</table>
{% endif -%}
{% if report_data.chkdb %}
<h2>Chkdb tests</h2>
<pre>{{ report_data.chkdb.report }}</pre>
{% if report_data.chkdb.report_is_too_long -%}
Chkdb report is too long, for full report please visit <a href="{{ report_data.chkdb.task_link }}" target="_blank">chkdb task</a>
{%- else -%}
Generated by <a href="{{ report_data.chkdb.task_link }}" target="_blank">chkdb task</a>
{% endif -%}
{% endif -%}
{% if report_data.stat_chkdb %}
<h2>Stat chkdb tests</h2>
<pre>{{ report_data.stat_chkdb.report }}</pre>
{% if report_data.stat_chkdb.report_is_too_long -%}
Stat chkdb report is too long, for full report please visit <a href="{{ report_data.stat_chkdb.task_link }}" target="_blank">stat chkdb task</a>
{%- else -%}
Generated by <a href="{{ report_data.stat_chkdb.task_link }}" target="_blank">stat chkdb task</a>
{% endif -%}
{% endif -%}
{% if report_data.meta_chkdb %}
<h2>Meta chkdb tests</h2>
<pre>{{ report_data.meta_chkdb.report }}</pre>
{% if report_data.meta_chkdb.report_is_too_long -%}
Meta chkdb report is too long, for full report please visit <a href="{{ report_data.meta_chkdb.task_link }}" target="_blank">meta chkdb task</a>
{%- else -%}
Generated by <a href="{{ report_data.meta_chkdb.task_link }}" target="_blank">meta chkdb task</a>
{% endif -%}
{% endif -%}
{% if report_data.stat_import_stability %}
<h2>Stat import stability tests</h2>
<pre>{{ report_data.stat_import_stability.report }}</pre>
Generated by <a href="{{ report_data.stat_import_stability.task_link }}" target="_blank">import_test_stability task</a>
{% endif -%}
{% if report_data.meta_import_stability %}
<h2>Meta import stability tests</h2>
<pre>{{ report_data.meta_import_stability.report }}</pre>
Generated by <a href="{{ report_data.meta_import_stability.task_link }}" target="_blank">import_test_stability task</a>
{% endif -%}
</div>
'''
